% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.rxTransform}
\alias{.rxTransform}
\title{rxode2 general transformation function}
\usage{
.rxTransform(
  x,
  lambda = 1,
  low = 0,
  high = 1,
  transform = c("boxCox", "yeoJohnson", "untransformed", "lnorm", "logit",
    "logit + yeoJohnson", "probit", "probit + yeoJohnson", "logit + boxCox",
    "probit + boxCox"),
  inverse = FALSE
)
}
\arguments{
\item{x}{value that will be transformed}

\item{lambda}{lambda value for the transformation}

\item{low}{lower bound for the transformation}

\item{high}{upper bound for the transformation}

\item{transform}{transformation to use (can be integer or string
matching supported transformations)}

\item{inverse}{boolean if the inverse transformation should be performed}
}
\value{
transformed value
}
\description{
rxode2 general transformation function
}
\examples{

logit(0.25)

.rxTransform(0.25, transform="logit")

expit(-1.09)

.rxTransform(-1.09, transform="logit", inverse=TRUE)

}
\author{
Matthew L. Fidler
}
\keyword{internal}
