% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fbestnormalize.R
\name{f_bestNormalize}
\alias{f_bestNormalize}
\title{f_bestNormalize: Automated Data Normalization with bestNormalize}
\usage{
f_bestNormalize(
  data,
  alpha = 0.05,
  plots = FALSE,
  data_name = NULL,
  output_type = "off",
  save_as = NULL,
  save_in_wdir = FALSE,
  close_generated_files = FALSE,
  open_generated_files = TRUE,
  ...
)
}
\arguments{
\item{data}{Numeric vector or single-column data frame.}

\item{alpha}{Numeric. Significance level for normality tests (default = \code{0.05}).}

\item{plots}{Logical. If \code{TRUE}, plots Q-Q plots and Histograms of the original and transformed data. Default is \code{FALSE}.}

\item{data_name}{A character string to manually set the name of the data for plot axis and reporting. Default extracts name from input object. \code{data}.}

\item{output_type}{Character string specifying the output format: \code{"pdf"}, \code{"word"}, \code{"rmd"}, \code{"off"} (no file generated) or \code{"console"}. The option \code{"console"} forces output to be printed. Default is \code{"off"}.}

\item{save_as}{Character string specifying the output file path (without extension).
If a full path is provided, output is saved to that location.
If only a filename is given, the file is saved in \code{tempdir()}.
If only a directory is specified (providing an existing directory with trailing slash),
the file is named "data_name_transformed" in that directory. If an extension is provided the output format specified with option "output_type" will be overruled.
Defaults to \code{file.path(tempdir(), "data_name_transformed.pdf")}.}

\item{save_in_wdir}{Logical. If \code{TRUE}, saves the file in the working directory. Default is \code{FALSE}, this avoid unintended changes to the global environment. If \code{save_as} location is specified \code{save_in_wdir} is overwritten by \code{save_as}.}

\item{close_generated_files}{Logical. If \code{TRUE}, closes open 'Word' files. This to be able to save the newly generated file by the \code{f_bestNormalize()} function. 'Pdf' files should also be closed before using the function and cannot be automatically closed. Default is \code{FALSE}.}

\item{open_generated_files}{Logical. If \code{TRUE}, Opens the generated output file, this to directly view the results after creation. Files are stored in tempdir(). Default is \code{TRUE}.}

\item{...}{Additional arguments passed to bestNormalize.}
}
\value{
Returns an object of class `f_bestNormalize` containing:
\itemize{
  \item \code{transformed_data} Normalized vector.
  \item \code{bestNormalize} Full bestNormalize object from original package.
  \item \code{data_name} Name of the analyzed dataset.
  \item \code{transformation_name} Name of selected transformation.
  \item \code{shapiro_original} Shapiro-Wilk test results for original data.
  \item \code{shapiro_transformed} Shapiro-Wilk test results for transformed data.
  \item \code{norm_stats} Data frame of normality statistics for all methods.
  \item \code{rmd} Rmd code if outputype = "rmd".
}
Also generates reports in specified formats, when using output to console and plots = TRUE, the function prints QQ-plots, Histograms and a summary data transformation report.

#' @return An object of class 'f_bestNormalize' containing results from \code{"bestNormalize"}, the input data, transformed data, Shapiro-Wilk test on original and transformed data. Using the option "output_type", it can also generate output in the form of: R Markdown code, 'Word', or 'pdf' files. Includes print and plot methods for objects of class 'f_bestNormalize'.
}
\description{
Applies optimal normalization transformations using 'bestNormalize',
provides diagnostic checks, and generates comprehensive reports.
}
\details{
This is a wrapper around the 'bestNormalize' package. Providing a fancy output and the settings  of 'bestNormalize' are tuned based on sample size n.
If n < 100, \code{loo = TRUE}, \code{allow_orderNorm = FALSE} and \code{r} doesn't matter as \code{loo = TRUE}.
If 100 <= n < 200, \code{loo = FALSE}, \code{allow_orderNorm = TRUE} and \code{r = 50}.
If n >= 200, \code{loo = FALSE}, \code{allow_orderNorm = TRUE}, \code{r = 10}. These setting can be overwritten by user options.

This function requires [Pandoc](https://github.com/jgm/pandoc/releases/tag) (version 1.12.3 or higher), a universal document converter.
\itemize{
\item \bold{Windows:} Install Pandoc and ensure the installation folder \cr (e.g., "C:/Users/your_username/AppData/Local/Pandoc") is added to your system PATH.
\item \bold{macOS:} If using Homebrew, Pandoc is typically installed in "/usr/local/bin". Alternatively, download the .pkg installer and verify that the binary’s location is in your PATH.
\item \bold{Linux:} Install Pandoc through your distribution’s package manager (commonly installed in "/usr/bin" or "/usr/local/bin") or manually, and ensure the directory containing Pandoc is in your PATH.

\item If Pandoc is not found, this function may not work as intended.
}
}
\examples{
\donttest{
# Create some skewed data (e.g., using a log-normal distribution).
skewed_data <- rlnorm(100, meanlog = 0, sdlog = 1)

# Use set.seed to keep the outcome of bestNormalize stable.
set.seed(123)

# Transform the data and store all information in f_bestNormalize_out.
f_bestNormalize_out <- f_bestNormalize(skewed_data)

# Print the output.
print(f_bestNormalize_out)

# Show histograms and QQplots.
plot(f_bestNormalize_out)

# Directly store the transformed_data from f_bestNormalize and force to show
# plots and transformation information.
transformed_data <- f_bestNormalize(skewed_data, output_type = "console")$transformed_data

# Any other transformation can be choosen by using:
boxcox_transformed_data <- f_bestNormalize(skewed_data)$bestNormalize$other_transforms$boxcox$x.t
# and substituting '$boxcox' with the transformation of choice.

#To print rmd output set chunck option to results = 'asis' and use:
f_bestNormalize_rmd_out <- f_bestNormalize(skewed_data, output_type = "rmd")
cat(f_bestNormalize_rmd_out$rmd)
}

}
\references{
Peterson, C. (2025). \pkg{bestNormalize}: Flexibly calculate the best normalizing transformation for a vector.
Available at: \url{https://cran.r-project.org/package=bestNormalize}
}
\author{
Sander H. van Delden  \email{plantmind@proton.me} \cr
}
