% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.R
\name{label_cooccur_igraph}
\alias{label_cooccur_igraph}
\title{Extract labels for plotting 'cooccur_igraph' object}
\usage{
label_cooccur_igraph(
  graph,
  max_graph_size = 30L,
  top_nodes = 3L,
  label_size_metric = c("betweenness", "numOfWords", "numOfScenes", "numOfSpeechActs",
    "degree", "weightedDegree", "closeness", "eigenvector")
)
}
\arguments{
\item{graph}{\code{cooccur_igraph} object to plot.}

\item{max_graph_size}{Integer, maximum network size for plotting all labels.
If you don't want to delete any labels, set \code{Inf}.}

\item{top_nodes}{Integer, number of labels to be plotted. Characters with the
highest number of words will be selected.}

\item{label_size_metric}{Character, a metric that is used to rank characters
in a play.}
}
\value{
Character vector of character names.
}
\description{
\code{label_cooccur_igraph()} returns labels for plotting \code{cooccur_igraph}
object. \code{label_cooccur_igraph}
gives control of overplotting for labels (i.e. character names) by deleting
extra labels if there are too many of them. Thus, it highlights the most
significant characters of the selected play. This function can be used to set
\code{vertex.label} parameter for \code{\link{plot.cooccur_igraph}}.
}
\details{
\code{label_cooccur_igraph} takes labels from a vertices data frame column
\code{"name"}, checks that network size is more than \code{max_graph_size},
if it is true, returns names for top \code{top_nodes} and NA for the rest.
}
\examples{
\donttest{
emilia_igraph <- get_net_cooccur_igraph(
  play = "lessing-emilia-galotti",
  corpus = "ger"
)
label_cooccur_igraph(emilia_igraph, max_graph_size = 10, top_nodes = 4)
}
}
\seealso{
\code{\link{get_net_cooccur_igraph}}
}
