% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.R
\name{get_text_chr_spoken}
\alias{get_text_chr_spoken}
\alias{get_text_chr_spoken_bych}
\alias{get_text_chr_stage}
\alias{get_text_chr_stage_with_sp}
\title{Retrieve lines and stage directions for a play}
\usage{
get_text_chr_spoken(
  play = NULL,
  corpus = NULL,
  gender = NULL,
  split_text = TRUE,
  ...
)

get_text_chr_spoken_bych(
  play = NULL,
  corpus = NULL,
  split_text = TRUE,
  as_data_frame = FALSE,
  ...
)

get_text_chr_stage(play = NULL, corpus = NULL, split_text = TRUE, ...)

get_text_chr_stage_with_sp(play = NULL, corpus = NULL, split_text = TRUE, ...)
}
\arguments{
\item{play}{Character, name of a play (you can find all play names in
\code{"playName"} column within an object returned by
\code{\link{get_dracor}}). Character vector (longer than 1) is not
supported.}

\item{corpus}{Character, name of the corpus (you can find all corpus names in
\code{name} column within an object returned by
\code{\link{get_dracor_meta}}).}

\item{gender}{Character, optional parameter to extract lines for characters
of specified gender: \code{"MALE"}, \code{"FEMALE"}, \code{"UNKNOWN"}.}

\item{split_text}{If \code{TRUE} returns text as a character vector of lines.
Otherwise, returns text as one character value. \code{TRUE} by default.}

\item{...}{Additional arguments passed to \code{\link{dracor_api}}.}

\item{as_data_frame}{If \code{TRUE} returns data frame with a row for every
character and text in a column \code{"text"}. Otherwise, a named list with
character values is returned. \code{FALSE} by default.}
}
\value{
For \code{get_text_chr_spoken()}, \code{get_text_chr_stage()} and
\code{get_text_chr_stage_with_sp()}: a character vector (if
\code{split_text = TRUE}, the default value) or a single character value (if
\code{split_text = FALSE)}.
For \code{get_text_chr_spoken_bych()}:
\describe{
  \item{\code{split_text = TRUE} and \code{as_data_frame = FALSE} (default)}{
  a named list with character vectors for every character}
  \item{\code{split_text = FALSE} and \code{as_data_frame = FALSE}}{a named
character vector (one value = one character)}
  \item{\code{split_text = TRUE} and \code{as_data_frame = TRUE}}{a data
  frame: every row represent a character, text of a play is stored in a
  \code{"text"} column, the \code{"text"} column is a list column with a
  character vector of lines}
  \item{\code{split_text = FALSE} and \code{as_data_frame = TRUE}}{a data
  frame: every row represent a character, text of a play is stored in a
  \code{"text"} column, the \code{"text"} column is a simple character
  column}
}
}
\description{
\code{get_text_chr_spoken()} request lines and stage directions for a play,
given play and corpus names.
}
\section{Functions}{
\itemize{
\item \code{get_text_chr_spoken_bych()}: Retrieves lines grouped by characters in a
play, given play and corpus names.

\item \code{get_text_chr_stage()}: Retrieves all stage directions of a play,
given play and corpus names.

\item \code{get_text_chr_stage_with_sp()}: Retrieves all stage directions of a play
including speakers (if applicable), given play and corpus names.

}}
\examples{
get_text_chr_spoken(play = "lessing-emilia-galotti", corpus = "ger")
get_text_chr_spoken(
  play = "lessing-emilia-galotti",
  corpus = "ger",
  gender = "FEMALE"
)
get_text_chr_spoken(
  play = "lessing-emilia-galotti",
  corpus = "ger",
  gender = "FEMALE",
  split_text = FALSE
)
get_text_chr_spoken_bych(
  play = "lessing-emilia-galotti",
  corpus = "ger"
)
get_text_chr_stage(
  play = "lessing-emilia-galotti",
  corpus = "ger"
)
get_text_chr_stage_with_sp(
  play = "lessing-emilia-galotti",
  corpus = "ger"
)
}
\seealso{
\code{\link{get_text_tei}} \code{\link{get_text_df}}
}
