% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2d.R
\name{hex_binning}
\alias{hex_binning}
\title{Hexagonal binning}
\usage{
hex_binning(nldr_scaled_obj, b1 = 30, q = 0.1)
}
\arguments{
\item{nldr_scaled_obj}{A list of a tibble contains scaled first and second columns
of NLDR data, and numeric vectors representing the limits of the original NLDR data.}

\item{b1}{Number of bins along the x axis.}

\item{q}{The buffer amount as proportion of data range.}
}
\value{
A object that contains numeric vector that contains binwidths (\code{a1}),
vertical distance (\code{a2}), bins along the x and y axes respectively (\code{bins}),
numeric vector that contains hexagonal
starting point coordinates all hexagonal bin centroids (\code{centroids}),
hexagonal coordinates of the full grid (\code{hex_poly}),
embedding components with their corresponding hexagon IDs (\code{data_hb_id}),
hex bins with their corresponding standardise counts (\code{std_cts}),
total number of hex bins (\code{b}), number of non-empty hex bins (\code{m})
and points within each hexagon (\code{pts_bins}).
}
\description{
This function generates the hexagonal object.
}
\examples{
hex_binning(nldr_scaled_obj = scurve_model_obj$nldr_scaled_obj, b1 = 30, q = 0.1)

}
