% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline.R
\name{pipeline}
\alias{pipeline}
\title{Run a Full Text Classification Pipeline on Preprocessed Text}
\usage{
pipeline(
  vect_method,
  model_name,
  text_vector,
  sentiment_vector,
  n_gram = 1,
  tune = FALSE,
  parallel = FALSE
)
}
\arguments{
\item{vect_method}{A string specifying the vectorization method.
Defaults to \code{"bag_of_words"}.
\itemize{
  \item \code{"bag_of_words"} (Alias: \code{"bow"}) - Standard count of words.
  \item \code{"term_frequency"} (Alias: \code{"tf"}) - Normalized counts.
  \item \code{"tfidf"} (Alias: \code{"tf-idf"}) - Term Frequency-Inverse Document Frequency.
  \item \code{"binary"} - Presence/Absence (1/0).
}}

\item{model_name}{A string specifying the model to train.
Defaults to \code{"logistic_regression"}.
\itemize{
  \item \code{"random_forest"} (Alias: \code{"rf"})
  \item \code{"xgboost"} (Alias: \code{"xgb"})
  \item \code{"logistic_regression"} (Alias: \code{"logit"}, \code{"glm"})
}}

\item{text_vector}{A character vector containing the **preprocessed** text.}

\item{sentiment_vector}{A vector or factor containing the target labels (e.g., ratings).}

\item{n_gram}{The n-gram size to use for BoW/TF-IDF. Defaults to 1.}

\item{tune}{Logical. If TRUE, the pipeline will perform hyperparameter tuning
for the selected model. Defaults to FALSE. [NEW]}

\item{parallel}{If TRUE, runs model training in parallel. Default FALSE.}
}
\value{
A list containing the trained model object, the DFM template,
  class levels, and a comprehensive evaluation report.
}
\description{
This function takes a data frame with pre-cleaned text and handles the
data splitting, vectorization, model training, and evaluation.
}
\examples{
df <- data.frame(
  text = c("good product", "excellent", "loved it", "great quality",
           "bad service", "terrible", "hated it", "awful experience",
           "not good", "very bad", "fantastic", "wonderful"),
  y = c("P", "P", "P", "P", "N", "N", "N", "N", "N", "N", "P", "P")
)


out <- pipeline("bow", "naive_bayes",  text_vector = df$text, sentiment_vector = df$y)

}
