% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nb.R
\name{nb_model}
\alias{nb_model}
\title{Multinomial Naive Bayes for Text Classification}
\usage{
nb_model(train_vectorized, Y, test_vectorized, parallel = FALSE, tune = FALSE)
}
\arguments{
\item{train_vectorized}{The training feature matrix (e.g., a `dfm` from quanteda).
This should be a sparse matrix.}

\item{Y}{The response variable for the training set. Should be a factor for
classification.}

\item{test_vectorized}{The test feature matrix, which must have the same
features as `train_vectorized`}

\item{parallel}{Logical}

\item{tune}{Logical. If TRUE, tests different Laplace smoothing values.}
}
\value{
A list containing four elements:
  \item{pred}{A vector of class predictions for the test set.}
  \item{probs}{A matrix of predicted probabilities.}
  \item{model}{The final, trained `naivebayes` model object.}
  \item{best_lambda}{Placeholder (NULL) for pipeline consistency.}
}
\description{
Multinomial Naive Bayes for Text Classification
}
\examples{
# 1. Create dummy numeric matrices with BOTH row and column names
train_matrix <- matrix(
  as.numeric(sample(0:5, 100, replace = TRUE)),
  nrow = 10, ncol = 10,
  dimnames = list(paste0("doc", 1:10), paste0("word", 1:10))
)

test_matrix <- matrix(
  as.numeric(sample(0:5, 50, replace = TRUE)),
  nrow = 5, ncol = 10,
  dimnames = list(paste0("doc", 1:5), paste0("word", 1:10))
)

# 2. Create dummy target variable
y_train <- factor(sample(c("P", "N"), 10, replace = TRUE))

# 3. Run model
model_results <- nb_model(train_matrix, y_train, test_matrix)
print(model_results$pred)
}
