% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_absolute_targets.R
\name{spec_absolute_targets}
\alias{spec_absolute_targets}
\title{Specify absolute targets}
\usage{
spec_absolute_targets(targets, ...)
}
\arguments{
\item{targets}{\code{numeric} vector that specifies targets for each
of the features. If a single value is specified, then all features
are assigned the same target threshold.}

\item{...}{not used.}
}
\value{
An object (\code{\linkS4class{TargetMethod}}) for specifying targets that
can be used with \code{\link[=add_auto_targets]{add_auto_targets()}} and \code{\link[=add_group_targets]{add_group_targets()}}
to add targets to a \code{\link[=problem]{problem()}}.
}
\description{
Specify targets expressed as the
same values as the underlying feature data (ignoring any specified
feature units).
For example, setting a target of 10 for a feature specifies that a solution
should ideally select a set of planning units that contain a total
(summed) value of, at least, 10 for the feature.
This function is designed to be used with \code{\link[=add_auto_targets]{add_auto_targets()}}.
}
\section{Mathematical formulation}{

This method involves setting target thresholds based on a pre-specified
value.
To express this mathematically, we will define the following terminology.
Let \eqn{a} the absolute target for a feature
(per \code{targets}).
Given this terminology, the target threshold (\eqn{t}) for the feature
is calculated as follows.
\deqn{t = a}
}

\examples{
\dontrun{
# set seed for reproducibility
set.seed(500)

# load data
sim_pu_raster <- get_sim_pu_raster()
sim_features <- get_sim_features()

# create base problem
p0 <-
  problem(sim_pu_raster, sim_features) \%>\%
  add_min_set_objective() \%>\%
  add_binary_decisions() \%>\%
  add_default_solver(verbose = FALSE)

# this function sets targets based on the total abundance of the features
# (i.e., sum of planning unit values for the feature) and does not
# consider the spatial area covered by the planning units

# create problem with absolute targets of 5 for each feature
p1 <-
  p0 \%>\%
  add_auto_targets(method = spec_absolute_targets(targets = 5))

# solve problem
s1 <- solve(p1)

# plot solution
plot(s1, main = "solution based on constant targets", axes = FALSE)

# targets can also be specified for each feature separately.
# to demonstrate this, we will set a target value for each
# feature based on a random number between 1 and 5
target_values <- runif(terra::nlyr(sim_features), 1, 5)

# create problem with targets defined separately for each feature
p2 <-
  p0 \%>\%
  add_auto_targets(method = spec_absolute_targets(targets = target_values))

# solve problem
s2 <- solve(p2)

# plot solution
plot(s2, main = "solution based on varying targets", axes = FALSE)
}
}
\seealso{
To add relative targets directly to a \code{\link[=problem]{problem()}}, see
\code{\link[=add_absolute_targets]{add_absolute_targets()}}.

Other target setting methods:
\code{\link{spec_area_targets}()},
\code{\link{spec_duran_targets}()},
\code{\link{spec_interp_absolute_targets}()},
\code{\link{spec_interp_area_targets}()},
\code{\link{spec_jung_targets}()},
\code{\link{spec_max_targets}()},
\code{\link{spec_min_targets}()},
\code{\link{spec_polak_targets}()},
\code{\link{spec_pop_size_targets}()},
\code{\link{spec_relative_targets}()},
\code{\link{spec_rl_ecosystem_targets}()},
\code{\link{spec_rl_species_targets}()},
\code{\link{spec_rodrigues_targets}()},
\code{\link{spec_rule_targets}()},
\code{\link{spec_ward_targets}()},
\code{\link{spec_watson_targets}()},
\code{\link{spec_wilson_targets}()}
}
\concept{methods}
