% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/category_vector.R
\name{category_vector}
\alias{category_vector}
\alias{category_vector.data.frame}
\alias{category_vector.sf}
\alias{category_vector.Spatial}
\alias{category_vector.matrix}
\title{Category vector}
\usage{
category_vector(x)

\method{category_vector}{data.frame}(x)

\method{category_vector}{sf}(x)

\method{category_vector}{Spatial}(x)

\method{category_vector}{matrix}(x)
}
\arguments{
\item{x}{\code{matrix}, \code{data.frame}, or \code{\link[sf:sf]{sf::sf()}} object.}
}
\value{
An \code{integer} vector.
}
\description{
Convert an object containing binary (\code{integer}) columns into a
\code{integer} vector indicating the column index where each row has the
highest value.
}
\details{
This function is conceptually similar to \code{\link[base:maxCol]{base::max.col()}}
except that rows with all values equal to zero value are assigned a
value of zero.
}
\examples{
# create matrix with logical columns
x <- matrix(c(1, 0, 0, NA, 0, 1, 0, NA, 0, 0, 0, NA), ncol = 3)

# print matrix
print(x)

# convert to category vector
y <- category_vector(x)

# print category vector
print(y)
}
\seealso{
The \code{\link[base:maxCol]{base::max.col()}} provides similar functionality.
}
