#' @title
#' Constructing a Linearly Ordered Set.
#'
#' @description
#' Constructs a linearly (or completely, or totally) ordered set (V,\eqn{\leq_{lin})}, starting from set \eqn{V},
#'
#' @param elements A character string vector containing the labels of the elements of \eqn{V} in ascending
#' order according to \eqn{\leq_{lin}}, i.e. such that `elements[h]`\eqn{ \leq_{lin} }`elements[k]`if and only if `h` \eqn{ \leq } `k`
#'
#' @return
#' An object of S4 class `LinearPOSet` (subclass of `POSet`)
#'
#' @examples
#' elems <- c("a", "b", "c", "d")
#' linpos <- LinearPOSet(elements = elems)
#'
#' @name LinearPOSet
#' @export LinearPOSet
LinearPOSet <- function(elements) {
  if (!is.character(elements))
    stop("elements must be character array")
  if (length(unique(elements)) != length(elements))
    stop("elements contains duplicated values")
  tryCatch({
    ptr <- .Call("_BuildLinearPoset", elements)
    result <- methods::new("LinearPOSet", ptr = ptr)
    return (result)
  }, error = function(err) {
    err_split <- strsplit(err[[1]], split = ":")
    stop(err_split[[1]][length(err_split[[1]])])
  }) # END tryCatch
}
