% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phoenix_immunologic.R
\name{phoenix_immunologic}
\alias{phoenix_immunologic}
\title{Phoenix Immunologic Score}
\usage{
phoenix_immunologic(anc = NA_real_, alc = NA_real_, data = parent.frame(), ...)
}
\arguments{
\item{anc}{absolute neutrophil count; a numeric vector; units of 1,000 cells per cubic millimeter}

\item{alc}{absolute lymphocyte count; a numeric vector; units of 1,000 cells per cubic millimeter}

\item{data}{a \code{list}, \code{data.frame}, or \code{environment} containing the input vectors}

\item{...}{pass through}
}
\value{
a integer vector with values 0 or 1

As with all other Phoenix organ system scores, missing values in the data
set will map to a score of zero - this is consistent with the development of
the criteria.
}
\description{
Apply the Phoenix immunologic scoring based on ANC and ALC.  This is only
part of Phoenix-8 and not Phoenix.
}
\section{Phoenix Immunologic Scoring}{

1 point if ANC < 0.500 or ALC < 1.000 (units are 1000 cells per cubic millimeter).
}

\examples{

# using the example sepsis data set
# Expected units for ALC and ANC are 1000 cells per cubic millimeter

immu_example <- sepsis[c("pid", "anc", "alc")]
immu_example$score <- phoenix_immunologic(anc, alc, sepsis)
immu_example

# example data set with all possilbe immunologic scores
# Expected units for anc and alc are 1000 cells per cubic millimeter

DF <- expand.grid(anc = c(NA, 0.200, 0.500, 0.600),
                  alc = c(NA, 0.500, 1.000, 2.000))
phoenix_immunologic(anc = anc, alc = alc, data = DF)

}
\references{
See reference details in \code{\link{phoenix-package}} or by calling
\code{citation('phoenix')}.
}
\seealso{
\itemize{
  \item \code{\link{phoenix}} for generating the diagnostic Phoenix
    Sepsis score based on the four organ systems:
    \itemize{
      \item \code{\link{phoenix_cardiovascular}},
      \item \code{\link{phoenix_coagulation}},
      \item \code{\link{phoenix_neurologic}},
      \item \code{\link{phoenix_respiratory}},
    }
  \item \code{\link{phoenix8}} for generating the diagnostic Phoenix 8
    Sepsis criteria based on the four organ systems noted above and
    \itemize{
      \item \code{\link{phoenix_endocrine}},
      \item \code{\link{phoenix_immunologic}},
      \item \code{\link{phoenix_renal}},
      \item \code{\link{phoenix_hepatic}},
    }
}

\code{vignette('phoenix')} for more details and examples.
}
