% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elo_model.R
\name{build_elo_data}
\alias{build_elo_data}
\title{Build EloChoice comparison data from pairwise results}
\usage{
build_elo_data(results)
}
\arguments{
\item{results}{A data frame or tibble with columns \code{ID1},
\code{ID2}, and \code{better_id}.}
}
\value{
A tibble with two columns:
\itemize{
\item \code{winner}: ID of the winning sample
\item \code{loser}: ID of the losing sample
}
Rows with invalid or missing \code{better_id} are dropped.
}
\description{
This function converts pairwise comparison results into the two-column
format used by the \pkg{EloChoice} package: one column for the winner and
one for the loser of each trial.
}
\details{
It assumes that the input contains columns \code{ID1}, \code{ID2}, and
\code{better_id}, where \code{better_id} is the ID of the better sample.
Rows where \code{better_id} does not match either \code{ID1} or \code{ID2}
(including \code{NA}) are excluded.
}
\examples{
results <- tibble::tibble(
  ID1       = c("S1", "S1", "S2", "S3"),
  ID2       = c("S2", "S3", "S3", "S4"),
  better_id = c("S1", "S3", "S2", "S4")
)

elo_data <- build_elo_data(results)
elo_data

}
