% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anthropic_batch_api.R
\name{anthropic_download_batch_results}
\alias{anthropic_download_batch_results}
\title{Download Anthropic Message Batch results (.jsonl)}
\usage{
anthropic_download_batch_results(
  batch_id,
  output_path,
  api_key = Sys.getenv("ANTHROPIC_API_KEY"),
  anthropic_version = "2023-06-01"
)
}
\arguments{
\item{batch_id}{Character scalar giving the batch ID.}

\item{output_path}{File path where the \code{.jsonl} results should be
written.}

\item{api_key}{Optional Anthropic API key. Defaults to
\code{Sys.getenv("ANTHROPIC_API_KEY")}.}

\item{anthropic_version}{Anthropic API version string passed as the
\code{anthropic-version} HTTP header. Defaults to \code{"2023-06-01"}.}
}
\value{
Invisibly, the \code{output_path}.
}
\description{
Once a Message Batch has finished processing (status \code{"ended"}),
Anthropic exposes a \code{results_url} field pointing to a \code{.jsonl}
file containing one JSON object per request result.
}
\details{
This helper downloads that file and writes it to disk. It is the
Anthropic counterpart to \code{openai_download_batch_output()}.
}
\examples{
\dontrun{
# Requires ANTHROPIC_API_KEY and network access.
final <- anthropic_poll_batch_until_complete(batch$id)
jsonl_path <- tempfile(fileext = ".jsonl")
anthropic_download_batch_results(final$id, jsonl_path)
}

}
