% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive.R
\name{orderly_interactive_set_search_options}
\alias{orderly_interactive_set_search_options}
\title{Set search options for interactive use}
\usage{
orderly_interactive_set_search_options(
  location = NULL,
  allow_remote = NULL,
  fetch_metadata = FALSE
)
}
\arguments{
\item{location}{Optional vector of locations to pull from. We
might in future expand this to allow wildcards or exceptions.}

\item{allow_remote}{Logical, indicating if we should allow packets
to be found that are not currently unpacked (i.e., are known
only to a location that we have metadata from). If this is
\code{TRUE}, then in conjunction with \code{\link[=orderly_dependency]{orderly_dependency()}}
you might pull a large quantity of data.  The default is \code{NULL}. This is
\code{TRUE} if remote locations are listed explicitly as a character
vector in the \code{location} argument, or if you have specified
\code{fetch_metadata = TRUE}, otherwise \code{FALSE}.}

\item{fetch_metadata}{Logical, indicating if we should pull
metadata immediately before the search. If \code{location} is given,
then we will pass this through to
\code{\link[=orderly_location_fetch_metadata]{orderly_location_fetch_metadata()}} to filter locations
to update.  If pulling many packets in sequence, you \emph{will} want
to update this option to \code{FALSE} after the first pull, otherwise
it will update the metadata between every packet, which will be
needlessly slow.}
}
\value{
Nothing, called for its side effects
}
\description{
Set search options for interactive use of orderly; see
\code{\link[=orderly_dependency]{orderly_dependency()}} and \code{\link[=orderly_run]{orderly_run()}} for
details. This applies only for the current session, but applies to
all interactive uses of orderly functions that might have received
a copy of the search options (\code{location}, \code{allow_remote} and
\code{fetch_metadata}) via \code{\link[=orderly_run]{orderly_run()}}.  Calling with no
arguments resets to the defaults.
}
\examples{
# enable fetching packets from remote locations in this session
orderly_interactive_set_search_options(allow_remote = TRUE)
# ... your interactive session
# reset to defaults
orderly_interactive_set_search_options()
}
