% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.R
\name{splitAll}
\alias{splitAll}
\title{Split all pairs name-level into columns.}
\usage{
splitAll(result, keep = FALSE, fill = "overall", exclude = "variable")
}
\arguments{
\item{result}{A data.frame.}

\item{keep}{Whether to keep the original name-level columns.}

\item{fill}{A character that specifies what value should be filled in when
missing.}

\item{exclude}{Name of a column pair to exclude.}
}
\value{
A dataframe with group, strata and additional as columns.
}
\description{
Pivots the input dataframe so any pair name-level columns are transformed
into columns (name) that contain values from the corresponding level.
}
\examples{
{
  library(dplyr)
  library(omopgenerics)

  x <- tibble(
    "result_id" = as.integer(c(1, 2)),
    "cdm_name" = c("cprd", "eunomia"),
    "group_name" = "cohort_name",
    "group_level" = "my_cohort",
    "strata_name" = "sex",
    "strata_level" = "male",
    "variable_name" = "Age group",
    "variable_level" = "10 to 50",
    "estimate_name" = "count",
    "estimate_type" = "numeric",
    "estimate_value" = "5",
    "additional_name" = "overall",
    "additional_level" = "overall"
  ) |>
    newSummarisedResult(settings = tibble(
      "result_id" = c(1, 2), "custom" = c("A", "B")
    ))

  x

  x |> splitAll()
}

}
