% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Shirley.r
\name{Shirley}
\alias{Shirley}
\title{Shirley Method for Nonparametric ANCOVA}
\usage{
Shirley(data, formula)
}
\arguments{
\item{data}{A data frame containing the variables specified in the formula.}

\item{formula}{An object of class "formula": a symbolic description of the 
model to be fitted. The structure should be `response ~ covariate1 + ... + group`.}
}
\value{
A list containing components related to the group and interaction effects, including:
\describe{
  \item{statistics_group}{The test statistic for the main group effect.}
  \item{p_value_group}{The p-value for the main group effect.}
  \item{df_group}{Degrees of freedom for the group effect.}
  \item{statistics_interaction}{The test statistic for the interaction effect.}
  \item{p_value_interaction}{The p-value for the interaction effect.}
  \item{df_interaction}{Degrees of freedom for the interaction effect.}
  \item{regression_equation_covariate}{Summary of the model with only covariates.}
  \item{regression_equation_covariate_group}{Summary of the model with covariates and group main effects.}
  \item{regression_equation_interaction}{Summary of the model including the interaction term.}
  \item{data}{The original data frame with added columns for ranks.}
}
}
\description{
Calculates group and interaction effects based on ranked response and
covariate variables using changes in R-squared values between models.
}
\examples{
# 1. Create a sample data frame
data <- data.frame(
  group = c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3),
  response = c(16, 60, 82, 126, 137, 44, 67, 87, 100, 142, 17, 28, 105, 149, 160),
  covariate1 = c(26, 10, 42, 49, 55, 21, 28, 5, 12, 58, 1, 19, 41, 48, 35),
  covariate2 = c(12, 21, 24, 29, 34, 17, 2, 40, 38, 36, 8, 1, 9, 28, 16)
)

# 2. Run the Shirley method
results <- Shirley(
  formula = response ~ covariate1 + covariate2 + group,
  data = data
)

# 3. View the results
print(results)
print(paste("Statistic:", results$statistics_group,
  "df_group:", results$df_group,
  "P-value:", results$p_value_group))

print(paste("Statistic:", results$statistics_interaction,
  "df_interaction:", results$df_interaction,
  "P-value:", results$p_value_interaction))

}
\references{
Burnett TD, Barr DRJE, Measurement P. A nonparametric analogy of analysis of covariance. 1977;37(2):341-8.

Olejnik SF, Algina JJER. A review of nonparametric alternatives to analysis of covariance. 1985;9(1):51-83.
}
