% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Puri_Sen_MB.r
\name{Puri_Sen_MB}
\alias{Puri_Sen_MB}
\title{Puri and Sen Method with Biased Variance-Covariance Matrix for Nonparametric ANCOVA: Multiple Covariates}
\usage{
Puri_Sen_MB(data, formula)
}
\arguments{
\item{data}{A data frame containing the variables specified in the formula.}

\item{formula}{An object of class "formula": a symbolic description of the 
model to be fitted. The structure should be `response ~ covariate1 + ... + group`.}
}
\value{
A list containing the following components:
\describe{
  \item{residuals}{A vector of residuals for each group.}
  \item{V}{The biased variance-covariance matrix.}
  \item{inverse_V}{The inverse of the variance-covariance matrix.}
  \item{L_statistic}{The Puri and Sen L-statistic.}
  \item{df}{The degrees of freedom for the test.}
  \item{p_value}{The corresponding p-value of the L-statistic.}
  \item{data}{The original data frame with added columns for ranks.}
}
}
\description{
Performs the Puri and Sen method for multiple covariates using a biased
variance-covariance matrix.
}
\examples{
# 1. Create a sample data frame
data <- data.frame(
  group = c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3),
  response = c(16, 60, 82, 126, 137, 44, 67, 87, 100, 142, 17, 28, 105, 149, 160),
  covariate1 = c(26, 10, 42, 49, 55, 21, 28, 5, 12, 58, 1, 19, 41, 48, 35),
  covariate2 = c(12, 21, 24, 29, 34, 17, 2, 40, 38, 36, 8, 1, 9, 28, 16)
)

# 2. Run the Puri and Sen (MB) method
results <- Puri_Sen_MB(
  formula = response ~ covariate1 + covariate2 + group,
  data = data
)

# 3. View the results
print(results) 
print(paste("Statistic:", results$L_statistic,"df:", results$df, "P-value:", results$p_value))

}
\references{
Puri ML, Sen PKJAoMS. Analysis of covariance based on general rank scores. 1969;40(2):610-8.

Olejnik SF, Algina JJER. A review of nonparametric alternatives to analysis of covariance. 1985;9(1):51-83.
}
