% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_graphcal.R
\name{graphcal_oral}
\alias{graphcal_oral}
\title{Graphical calculation of pharmacokinetic parameters for oral administration}
\usage{
graphcal_oral(dat, dose = 1, ...)
}
\arguments{
\item{dat}{A data frame containing TIME (time after dosing) and DV (observed
concentration).}

\item{dose}{Administered dose amount. Defaults to 1.}

\item{...}{Additional arguments passed to \code{find_best_lambdaz()}.}
}
\value{
A list containing graphical estimates of ka, kel, lambda_z, C0exp,
Vd/F, and Cl/F.
}
\description{
Estimates key pharmacokinetic parameters from oral concentration–time data using
graphical methods, including absorption rate constant (ka), elimination rate
constant (kel), terminal slope, extrapolated concentration (C0exp), apparent
volume of distribution (Vd/F), and clearance (Cl/F).
}
\details{
The terminal slope (lambdaz) is estimated using \code{force_find_lambdaz()}. The
apparent volume of distribution and clearance are computed using the
following relationships:
\deqn{Vd/F = \frac{Dose \times ka}{C_0 \times (ka - kel)}}
\deqn{Cl/F = kel \times Vd/F}
where \code{ka} is estimated from the absorption phase.
}
\examples{
dat <- data.frame(TIME = c(0.5, 1, 2, 4, 6, 8, 10),
                  DV = c(1, 2, 5, 3, 2, 1.5, 1))
graphcal_oral(dat, dose = 100, route = "oral")

}
\seealso{
\code{\link{find_best_lambdaz}}
}
\author{
Zhonghui Huang
}
