% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs.R
\name{graph_from_multi_edgelist}
\alias{graph_from_multi_edgelist}
\title{Multiple networks from a single edgelist with a typed attribute}
\usage{
graph_from_multi_edgelist(
  d,
  from = NULL,
  to = NULL,
  type = NULL,
  weight = NULL,
  directed = FALSE
)
}
\arguments{
\item{d}{data frame.}

\item{from}{column name of sender. If NULL, defaults to first column.}

\item{to}{column of receiver. If NULL, defaults to second column.}

\item{type}{type attribute to split the edgelist. If NULL, defaults to third column.}

\item{weight}{optional column name of edge weights. Ignored if NULL.}

\item{directed}{logical scalar, whether or not to create a directed graph.}
}
\value{
list of igraph objects.
}
\description{
Create a list of igraph objects from an edgelist according to a type attribute
}
\examples{
library(igraph)
d <- data.frame(
    from = rep(c(1, 2, 3), 3), to = rep(c(2, 3, 1), 3),
    type = rep(c("a", "b", "c"), each = 3), weight = 1:9
)
graph_from_multi_edgelist(d, "from", "to", "type", "weight")
}
\author{
David Schoch
}
