#' Identity link
#'
#' @param x numeric
#' @param ... not used
#'
#' @return a numeric
#' @keywords internal
identityLink = function(x, ...) {
  x[x<0] = 1.0e-6
  return(x)
}

#' Identity inverse link
#'
#' @param x numeric
#' @param ... not used
#'
#' @return a numeric
#' @keywords internal
identityInvLink = function(x, ...) {
  x[x<0] = 1.0e-6
  return(x)
}

#' Log link
#'
#' @param x numeric
#' @param ... not used
#'
#' @return a numeric
#' @keywords internal
logLink = function(x, ...) {
  x = log(x)
  return(x)
}

#' Log Inverse link
#'
#' @param x numeric
#' @param ... not used
#'
#' @return a numeric
#' @keywords internal
logInvLink = function(x, ...) {
  x = exp(x)
  return(x)
}


#' Yeo-Johnson transformation with parameter k
#'
#' @param x numeric, the variable to be transformed
#' @param k numeric, the power
#'
#' @return a numeric
#' @keywords internal
yeoJohnson = function(x, k=1) {
  s = sign(x)
  z = abs(x)+1
  if (k==0) return(s*log(z))
  else {
    l = s*(k-1)+1
    return(s*(z^l-1)/l)
  }
}

#' Inverse Yeo-Johnson transformation with parameter k
#'
#' @param x numeric, the variable to be transformed
#' @param k numeric, the power
#'
#' @return a numeric
#' @keywords internal
yeoJohnsonInv = function(x, k=1) {
  s = sign(x)
  if (k==0) return(s*(exp(s*x)-1))
  else {
    k = s*(k-1)+1
    return(s*((k*x+1)^(1/k)))
  }
}

#' Yeo-Johnson link
#'
#' @param x numeric
#' @param k numeric, the power

#'
#' @return a numeric
#' @keywords internal
yjInvLink = function(x, k=1) {
  exp(yeoJohnson(x,k))
}

#' Inverse Yeo-Johnson link
#'
#' @param x numeric
#' @param k numeric, the power

#'
#' @return a numeric
#' @keywords internal
yjLink = function(x, k=1) {
  log(yeoJohnsonInv(x,k))
}
