% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_zeta.R
\name{func_zeta}
\alias{func_zeta}
\title{Function: Decay Rate}
\usage{
func_zeta(value0, values, reward, params, system, ...)
}
\arguments{
\item{value0}{The initial values for all actions.}

\item{values}{The current expected values for all actions.}

\item{reward}{The feedback received by the agent from the environment at trial(t) 
following the execution of action(a)}

\item{params}{Parameters used by the model’s internal functions,
see \link[multiRL]{params}}

\item{system}{When the agent makes a decision, is a single system at work, or are multiple 
systems involved?
  see \link[multiRL]{system}}

\item{...}{It currently contains the following information; additional information 
   may be added in future package versions.
\itemize{
  \item idinfo: 
     \itemize{
       \item subid
       \item block
       \item trial
     }
  \item exinfo: 
     contains information whose column names are specified by the user.
     \itemize{
       \item Frame
       \item RT
       \item NetWorth
       \item ...
     }
  \item behave: 
     includes the following:
     \itemize{
       \item action: 
         the behavior performed by the human in the given trial.
       \item latent: 
         the object updated by the agent in the given trial.
       \item simulation: 
         the actual behavior performed by the agent.
     }
}}
}
\value{
A \code{NumericVector} representing the values of unchosen options 
   after decay according to the decay rate.
}
\description{
\deqn{W_{new} = W_{old} + \zeta \cdot (W_{0} - W_{old})}
}
\section{Body}{
 
\preformatted{func_zeta <- function(
    value0, 
    values,
    reward,
    params,
    ...
){

  list2env(list(...), envir = environment())
  
  # If you need extra information(...)
  # Column names may be lost(C++), indexes are recommended
  # e.g.
  # Trial  <- idinfo[3]
  # Frame  <- exinfo[1]
  # Action <- behave[1]
  
  zeta       <-  params[["zeta"]]
  bonus      <-  params[["bonus"]]
  
  if (reward == 0) {
    decay <- values + zeta * (value0 - values)
  } else if (reward < 0) {
    decay <- values + zeta * (value0 - values) + bonus
  } else if (reward > 0) {
    decay <- values + zeta * (value0 - values) - bonus
  }
  
  return(decay)
}
}
}

