% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cronbachs_alpha.R
\name{cronbachs_alpha}
\alias{cronbachs_alpha}
\title{Compute Lower and Upper Bound of Cronbach's Alpha}
\usage{
cronbachs_alpha(
  scores_mat,
  score_max,
  tol = 0.001,
  num_random = 1000,
  enum_all = FALSE,
  rough = FALSE,
  num_opt = 1,
  int_only = TRUE,
  method = "GA",
  ...
)
}
\arguments{
\item{scores_mat}{A matrix where rows represent persons and columns represent tests (or items),
providing the performance of a person on a test. NA should be used for missing values.}

\item{score_max}{An integer indicating the largest possible score of the test.}

\item{tol}{A numeric value representing the desired accuracy in computing the lower and upper bound of Cronbach's alpha.}

\item{num_random}{An integer specifying the number of random samples used in estimating the lower and upper bound. Default is 1000.}

\item{enum_all}{A logical value indicating whether to enumerate all possible scores for Cronbach's alpha. Default is FALSE.}

\item{rough}{A logical value indicating whether to compute a rough approximation of Cronbach's alpha bounds. Default is FALSE.}

\item{num_opt}{An integer specifying the number of times to run the optimization algorithm. Default is 1.}

\item{int_only}{A logical value indicating whether the random sampling should be restricted to integer-only scores. Default is TRUE.}

\item{method}{A character string specifying the optimization method to be used ('GA', 'DEoptim', 'nloptr'). Default is 'GA'.}

\item{...}{Additional parameters passed to the optimization algorithm.}
}
\value{
A list containing:
\item{alpha_min_opt}{The smallest possible Cronbach's alpha computed by the optimization algorithm (if used).}
\item{alpha_max_opt}{The largest possible Cronbach's alpha computed by the optimization algorithm (if used).}
\item{alpha_min_enum}{The smallest possible Cronbach's alpha obtained by enumerating all possible scores (if used).}
\item{alpha_max_enum}{The largest possible Cronbach's alpha obtained by enumerating all possible scores (if used).}
\item{alpha_min_rough}{The smallest possible Cronbach's alpha obtained by rough approximation (if used).}
\item{alpha_max_rough}{The largest possible Cronbach's alpha obtained by rough approximation (if used).}
\item{method}{The optimization method used.}
\item{runtime}{The total computation time in seconds.}
}
\description{
This function computes the lower and upper bound of Cronbach's alpha
using various methods such as enumeration, random sampling, or
optimization algorithms. The function also supports rough approximations
and allows integer-only or floating-point scores during sampling.
}
\examples{
\donttest{
# Example 1: Run `cronbachs_alpha` with a sample matrix
scores_mat <- matrix(c(
  NaN, 1, 0, 0, 0, 0, 0, 0, NaN, 0, 0, 0,
  2, 0, 0, 1, NaN, 0, 0, 0, 0, 0, 0, 0,
  1, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1
), nrow = 10, ncol = 4, byrow = TRUE)

result <- cronbachs_alpha(scores_mat, score_max = 4, enum_all = FALSE)
print(result$alpha_min_opt)
print(result$alpha_max_opt)

# Example 2: Generate a Bernoulli matrix and compute Cronbach's alpha
score_max <- 2
scores_mat_bernoulli <- generate_scores_mat_bernoulli(50, 10, 20, score_max)
result <- cronbachs_alpha(scores_mat_bernoulli, score_max, enum_all = FALSE)
print(result$alpha_min_opt)
print(result$alpha_max_opt)

# Example 3: Using a predefined dataset from missalpha
scores_df <- missalpha::sample
scores_mat <- as.matrix(scores_df)
result <- cronbachs_alpha(scores_mat, score_max = 4, enum_all = FALSE)
print(result$alpha_min_opt)
print(result$alpha_max_opt)
}

}
\seealso{
\code{\link{compute_alpha_min}}, \code{\link{compute_alpha_max}}, \code{\link{cronbach_alpha_enum}}, \code{\link{cronbach_alpha_rough}}, \code{\link{generate_scores_mat_bernoulli}}, \code{\link{qp_solver}}
}
