% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_matrix_hair.R
\name{error_matrix_hair}
\alias{error_matrix_hair}
\title{Hair Color Error/Confusion Matrix}
\usage{
error_matrix_hair(
  errorModel = c("custom", "uniform")[1],
  ep = 0.01,
  ep12 = 0.01,
  ep13 = 0.005,
  ep14 = 0.01,
  ep15 = 0.003,
  ep23 = 0.01,
  ep24 = 0.003,
  ep25 = 0.01,
  ep34 = 0.003,
  ep35 = 0.003,
  ep45 = 0.01
)
}
\arguments{
\item{errorModel}{Character. Type of error model to use:
\itemize{
\item "custom": Use specific error rates for each color pair (default)
\item "uniform": Use a single error rate for all color pairs
}}

\item{ep}{Numeric (0-1). Base error rate used when errorModel = "uniform".
Represents the probability of confusing any two different colors.
Default: 0.01.}

\item{ep12}{Numeric. Error rate between colors 1 (Black) and 2 (Brown).
Default: 0.01.}

\item{ep13}{Numeric. Error rate between colors 1 (Black) and 3 (Blonde).
Default: 0.005.}

\item{ep14}{Numeric. Error rate between colors 1 (Black) and 4 (Red).
Default: 0.01.}

\item{ep15}{Numeric. Error rate between colors 1 (Black) and 5 (Gray/White).
Default: 0.003.}

\item{ep23}{Numeric. Error rate between colors 2 (Brown) and 3 (Blonde).
Default: 0.01.}

\item{ep24}{Numeric. Error rate between colors 2 (Brown) and 4 (Red).
Default: 0.003.}

\item{ep25}{Numeric. Error rate between colors 2 (Brown) and 5 (Gray/White).
Default: 0.01.}

\item{ep34}{Numeric. Error rate between colors 3 (Blonde) and 4 (Red).
Default: 0.003.}

\item{ep35}{Numeric. Error rate between colors 3 (Blonde) and 5 (Gray/White).
Default: 0.003.}

\item{ep45}{Numeric. Error rate between colors 4 (Red) and 5 (Gray/White).
Default: 0.01.}
}
\value{
A 5x5 numeric matrix where:
\itemize{
\item Rows represent true hair colors (1-5)
\item Columns represent observed hair colors (1-5)
\item Cell (i,j) = P(observed color j | true color i)
\item Each row sums to 1
\item Diagonal elements are highest (correct observations)
}
Hair color codes: 1=Black, 2=Brown, 3=Blonde, 4=Red, 5=Gray/White.
}
\description{
Creates a 5x5 error matrix (also known as confusion matrix) that models
the probability of observing each hair color given the true hair color.
This accounts for observation errors in hair color classification.

The matrix rows represent the true hair color of the missing person,
and columns represent the observed hair color. Each row sums to 1,
indicating that some color must be observed.
}
\details{
The error rates are symmetric: the probability of confusing color A with
color B equals the probability of confusing B with A.

The diagonal elements (correct observations) are calculated to ensure
each row sums to 1:
\deqn{P(i|i) = 1 / (1 + \sum_{j \neq i} ep_{ij})}

Lower error rates between dissimilar colors (e.g., black and blonde)
and higher rates between similar colors (e.g., brown and red) reflect
realistic observation patterns.
}
\examples{
# Default custom error model
emat <- error_matrix_hair()
print(round(emat, 4))

# Verify rows sum to 1
rowSums(emat)

# Uniform error model with 2\% error rate
emat_uniform <- error_matrix_hair(errorModel = "uniform", ep = 0.02)
print(round(emat_uniform, 4))

# Higher error rates for similar colors
emat_custom <- error_matrix_hair(
  errorModel = "custom",
  ep12 = 0.05,  # Black-Brown confusion more likely
  ep23 = 0.05,  # Brown-Blonde confusion more likely
  ep34 = 0.05   # Blonde-Red confusion more likely
)
}
\references{
Marsico FL, et al. (2023). "Likelihood ratios for non-genetic evidence
in missing person cases." \emph{Forensic Science International: Genetics},
66, 102891. \doi{10.1016/j.fsigen.2023.102891}
}
\seealso{
\code{\link{cpt_missing_person}} which uses this matrix,
\code{\link{lr_hair_color}} for hair color LR calculations.
}
