% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{dataset}
\alias{dataset}
\title{The dataset structured with microtable class for the demonstration of examples}
\format{
R6 class object
}
\usage{
data(dataset)
}
\description{
The dataset arose from 16S rRNA gene amplicon sequencing of wetland soils in China <doi:10.1016/j.geoderma.2018.09.035>. 
In \code{dataset$sample_table}, the 'Group' column means Chinese inland wetlands (IW), coastal wetland (CW) and Tibet plateau wetlands (TW).
The column 'Type' denotes the sampling region: northeastern region (NE), northwest region (NW), North China area (NC), 
middle-lower reaches of the Yangtze River (YML), southern coastal area (SC), upper reaches of the Yangtze River (YU) and Qinghai-Tibet Plateau (QTP). 
The column 'Saline' represents the saline soils and non-saline soils.
}
\details{
\itemize{
  \item sample_table: sample information table
  \item otu_table: species-sample abundance table
  \item tax_table: taxonomic table
  \item phylo_tree: phylogenetic tree
  \item taxa_abund: taxa abundance list with several tables for Phylum...Genus
  \item alpha_diversity: alpha diversity table
  \item beta_diversity: list with several beta diversity distance matrix
}
}
\keyword{datasets}
