% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_elixhauser_codes.R
\name{get_elixhauser_codes}
\alias{get_elixhauser_codes}
\title{Get Elixhauser Codes}
\usage{
get_elixhauser_codes()
}
\value{
A \code{data.frame} with the following columns:
\itemize{
\item \code{icdv}: Integer vector indicating if the code is from ICD-9 or ICD-10
\item \code{dx}: Integer vector.  1 if the code is a diagnostic, (ICD-9-CM, ICD-10-CM, WHO, CDC Mortality), or 0 if the code is procedural (ICD-9-PCS, ICD-10-PCS)
\item \code{full_code}: Character vector with the ICD code and any relevant decimal point
\item \code{code}: Character vector with the compact ICD code omitting any relevant decimal point
\item \code{condition}: Character vector of the conditions
\item \verb{elixhauser_<variant>}: Integer vector indicating if the code is part of the \verb{<variant>} of the Elixhauser comorbidities.
}
}
\description{
Retrieve  copy of internal lookup tables for the ICD codes used in assessing
Elixhauser comorbidities.
}
\examples{
head(get_elixhauser_codes())
str(get_elixhauser_codes())

}
\seealso{
\itemize{
\item \code{\link[=get_elixhauser_index_scores]{get_elixhauser_index_scores()}} for the lookup table of the condition by
condition scores for mortality and readmission indices.
\item \code{\link[=get_elixhauser_poa]{get_elixhauser_poa()}} for the lookup table of the conditions which do an
do not require associated ICD codes to be present-on-admission to flag the
comorbidity.
\item \code{\link[=get_icd_codes]{get_icd_codes()}} for the lookup table of all ICD codes.
\item \code{\link[=get_pccc_codes]{get_pccc_codes()}} for the lookup table of ICD codes used for the PCCC.
\item \code{\link[=get_charlson_codes]{get_charlson_codes()}} for the lookup table of ICD codes used for the Charlson comorbidities.
\item \code{\link[=comorbidities]{comorbidities()}} for applying comorbidity algorithms to a data set.
}
}
