% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dim_match.R
\name{wif_match}
\alias{wif_match}
\title{Match Datasets with Differing Scenarios}
\usage{
wif_match(x, y, by = NULL)
}
\arguments{
\item{x}{(data frame). First dataset to match.}

\item{y}{(data frame). Second dataset to match.}

\item{by}{(character vector, optional). Grouping column name(s) to match on.
If NULL, auto-detected from column names. Default: NULL.}
}
\value{
A list containing matched datasets with aligned scenario IDs.
Element 1: matched version of x. Element 2: matched version of y.
}
\description{
Matches datasets by group and preserves baseline scenarios (scenario_id = 0)
when scenarios differ between them.
}
\examples{
x <- data.frame(
  category = c("a", "b", "a", "b"),
  scenario_id = c(0, 0, 1, 1),
  value = 1:4
)

y <- data.frame(
  category = c("a", "b", "a", "b"),
  scenario_id = c(0, 0, 2, 2),
  value = 5:8
)

# Automatic matching
result <- wif_match(x, y)

}
