% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/which_mcnode.R
\name{which_mcnode_na}
\alias{which_mcnode_na}
\title{Find \code{mcnode}s with Missing Values}
\usage{
which_mcnode_na(mcmodule)
}
\arguments{
\item{mcmodule}{(mcmodule object). Module containing node_list.}
}
\value{
Character vector of mcnode names containing NA values. Returns empty
vector if no NAs found.
}
\description{
Find mcnodes with Missing Values
}
\details{
Identifies which mcnodes within an mcmodule contain NA values.
Useful for troubleshooting and debugging Monte Carlo models.
}
\examples{
# Find nodes with NAs in the imports_mcmodule
which_mcnode_na(imports_mcmodule)

# Create a test mcmodule with NAs
test_mcnode_na <- mcdata(c(0.1, NA, 0.3), type = "0", nvariates = 3)
test_mcnode_clean <- mcdata(c(0.1, 0.2, 0.3), type = "0", nvariates = 3)
test_mcmodule <- list(
  node_list = list(
    node_a = list(mcnode = test_mcnode_na),
    node_b = list(mcnode = test_mcnode_clean)
  )
)
which_mcnode_na(test_mcmodule)

}
\seealso{
\code{\link[=which_mcnode]{which_mcnode()}}, \code{\link[=which_mcnode_inf]{which_mcnode_inf()}}, \code{\link[=mcnode_na_rm]{mcnode_na_rm()}}
}
