% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_plot.R
\name{tidy_mcnode}
\alias{tidy_mcnode}
\title{Convert mcnode to Long Format for Plotting}
\usage{
tidy_mcnode(
  mcmodule = NULL,
  mc_name = NULL,
  mcnode = NULL,
  data = NULL,
  keys_names = NULL,
  filter = NULL
)
}
\arguments{
\item{mcmodule}{(mcmodule object, optional). Module containing the node.}

\item{mc_name}{(character, optional). Name of the mcnode in the module.}

\item{mcnode}{(mcnode object, optional). mcnode to convert directly.}

\item{data}{(data frame, optional). Input data; extracted from \code{mcmodule} if NULL.
Default: NULL.}

\item{keys_names}{(character vector, optional). Column names for grouping variates.
If NULL, uses node keys from module or all available keys. Default: NULL.}

\item{filter}{(expression, optional). Unquoted expression to filter variates
(e.g., \code{pathogen == "a"} or \code{origin == "nord"}). Evaluated in context of
keys data frame. Default: NULL.}
}
\value{
A long data frame with columns:
\itemize{
\item All key columns from \code{keys_names}.
\item variate: Variate index (data row number).
\item simulation: Uncertainty iteration index.
\item value: mcnode value for that combination.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Converts an mcnode to long format suitable for ggplot2 and tidyverse analysis.
Each row represents one uncertainty iteration for one variate.
}
\details{
Call signatures:
\itemize{
\item \verb{tidy_mcnode(mcmodule, \\"node_name\\")}
\item \code{tidy_mcnode(mcnode = mcnode, data = data)}
\item \code{tidy_mcnode(mcmodule, mcnode = mcnode)}
}
}
\examples{
# Using mcmodule and node name
long_data <- tidy_mcnode(imports_mcmodule, "w_prev")

# Using with specific keys
long_data <- tidy_mcnode(imports_mcmodule, "w_prev",
  keys_names = "origin"
)

# Using mcnode and data directly
w_prev <- imports_mcmodule$node_list$w_prev$mcnode
long_data <- tidy_mcnode(mcnode = w_prev, data = imports_data)

# Filter variates
long_data <- tidy_mcnode(imports_mcmodule, "w_prev",
  filter = pathogen == "a"
)

}
