% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcnode_na_rm.R
\name{mcnode_na_rm}
\alias{mcnode_na_rm}
\title{Replace NA and Infinite Values in mcnode Objects}
\usage{
mcnode_na_rm(mcnode, na_value = 0)
}
\arguments{
\item{mcnode}{An mcnode object containing NA or infinite values}

\item{na_value}{Numeric value to replace NA and infinite values (default = 0)}
}
\value{
An mcnode object with NA and infinite values replaced by na_value
}
\description{
Replaces NA and infinite values in mcnode objects with a specified value.
}
\examples{
sample_mcnode <- mcstoc(runif,
               min = mcdata(c(NA, 0.2, -Inf), type = "0", nvariates = 3),
               max = mcdata(c(NA, 0.3, Inf), type = "0", nvariates = 3),
               nvariates = 3
)
# Replace NA and Inf with 0
clean_mcnode <- mcnode_na_rm(sample_mcnode)

}
