% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmodule_info.R
\name{mcmodule_info}
\alias{mcmodule_info}
\title{Get Comprehensive Monte Carlo Module Information}
\usage{
mcmodule_info(mcmodule)
}
\arguments{
\item{mcmodule}{A Monte Carlo module object}
}
\value{
A list with six elements:
\item{is_combined}{Logical. TRUE if module is combined, FALSE if raw}
\item{n_modules}{Integer. Number of component modules (1 for raw, >1 for combined)}
\item{module_names}{Character vector. Names of all component modules (recursive)}
\item{module_exp_data}{Data frame with module and expression information, including data_name}
\item{data_keys}{Data frame with keys for each variate, including variate number and data_name}
\item{global_keys}{Character vector of global key names used across the module}
}
\description{
Extracts comprehensive metadata about a Monte Carlo module, including:
\itemize{
\item Module composition (raw vs combined modules)
\item Input data per expression
\item Keys for each variate (data row)
\item Global data keys
}
}
\details{
A raw module has a single expression in \code{mcmodule$exp}.
A combined module has multiple expressions in \code{mcmodule$exp}, each
representing a component module that was combined via \code{combine_modules()}.

For combined modules, module names are recursively extracted up to one level deep.
This allows identifying all base modules even in deeply nested combinations.
}
\examples{
# Get comprehensive module information
info <- mcmodule_info(imports_mcmodule)
str(info)

# Access composition information
info$is_combined
info$n_modules
info$module_names

# Access index information
head(info$module_exp_data)
head(info$data_keys)
info$global_keys

}
