% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_analysis.R
\name{mcmodule_corr}
\alias{mcmodule_corr}
\title{Calculate Correlation Coefficients Between Inputs and Outputs}
\usage{
mcmodule_corr(
  mcmodule,
  output = NULL,
  by_exp = FALSE,
  match_variates = TRUE,
  variates_as_nsv = FALSE,
  print_summary = TRUE,
  progress = FALSE,
  method = c("spearman", "kendall", "pearson"),
  use = "all.obs",
  lim = c(0.025, 0.975)
)
}
\arguments{
\item{mcmodule}{(mcmodule object). Module containing simulation results.}

\item{output}{(character, optional). Output node name. If NULL (default), uses
the last node in \code{mcmodule$node_list}. If \code{by_exp = TRUE}, uses the last
output node per expression. Default: NULL.}

\item{by_exp}{(logical). If TRUE, calculate correlations by expression output;
if FALSE, use global output (last node). Default: FALSE.}

\item{match_variates}{(logical). If TRUE, match input nodes to output variates
when data dimensions differ. Default: TRUE.}

\item{variates_as_nsv}{(logical). If TRUE, combine all variates into one \code{mc}
object; if FALSE, analyse each variate separately. See \code{mcmodule_to_mc()}.
Default: FALSE.}

\item{print_summary}{(logical). If TRUE, print correlation analysis summary.
Default: TRUE.}

\item{progress}{(logical). If TRUE, print progress information while running.
Default: FALSE.}

\item{method}{(character). Correlation coefficient type: "spearman" (default),
"kendall", or "pearson". See \code{stats::cor()}. Default: "spearman".}

\item{use}{(character). Method for handling missing values: "all.obs",
"complete.obs", or "pairwise.complete.obs". See \code{stats::cor()}.
Default: "all.obs".}

\item{lim}{(numeric vector). Quantiles for credible interval computation (reserved
for two-dimensional models). Default: \code{c(0.025, 0.975)}.}
}
\value{
A data frame with correlation coefficients and metadata. Columns include:
\itemize{
\item exp: Expression name
\item exp_n: Expression number
\item variate: Variate number
\item output: Output node name
\item input: Input node name
\item value: Correlation coefficient value
\item strength: Qualitative strength of association (Very strong, Strong, Moderate, Weak, None)
\item method: Correlation method used (spearman, kendall, or pearson)
\item use: Method for handling missing values (passed to the correlation function)
\item warnings: Any warnings generated during correlation calculation (if present)
\item Additional columns for global keys (e.g., pathogen, origin)
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Computes correlation coefficients between mcmodule inputs and outputs using
tornado analysis (from the \code{mc2d} package). Supports multiple correlation methods
and captures warnings generated during calculation.
}
\examples{
mcmodule <- agg_totals(
  mcmodule = imports_mcmodule,
  mc_name = "no_detect_a",
  agg_keys = "pathogen"
)
cor_results <- mcmodule_corr(mcmodule)

# Use single method
cor_results_spearman <- mcmodule_corr(mcmodule, method = "spearman")

}
