% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dim_match.R
\name{mc_match}
\alias{mc_match}
\title{Match Two Monte Carlo Nodes}
\usage{
mc_match(mcmodule, mc_name_x, mc_name_y, keys_names = NULL)
}
\arguments{
\item{mcmodule}{(mcmodule object). Module containing nodes.}

\item{mc_name_x}{(character). First mcnode name.}

\item{mc_name_y}{(character). Second mcnode name.}

\item{keys_names}{(character vector, optional). Column names for matching.
Default: NULL.}
}
\value{
A list containing matched nodes and combined keys (\code{keys_xy}).
}
\description{
Matches two mcnodes by aligning groups, scenarios, or adding missing
groups across different scenarios.
}
\details{
Matching proceeds in order:
\enumerate{
\item Group matching — align nodes with same scenarios but different group order
\item Scenario matching — align nodes with same groups but different scenarios
\item Null matching — add missing groups across different scenarios
}
}
\examples{
test_module <- list(
  node_list = list(
    node_x = list(
      mcnode = mcstoc(runif,
        min = mcdata(c(1, 2, 3), type = "0", nvariates = 3),
        max = mcdata(c(2, 3, 4), type = "0", nvariates = 3),
        nvariates = 3
      ),
      data_name = "data_x",
      keys = c("category")
    ),
    node_y = list(
      mcnode = mcstoc(runif,
        min = mcdata(c(5, 6, 7), type = "0", nvariates = 3),
        max = mcdata(c(6, 7, 8), type = "0", nvariates = 3),
        nvariates = 3
      ),
      data_name = "data_y",
      keys = c("category")
    )
  ),
  data = list(
    data_x = data.frame(
      category = c("A", "B", "C"),
      scenario_id = c("0", "0", "0")
    ),
    data_y = data.frame(
      category = c("B", "B", "B"),
      scenario_id = c("0", "1", "2")
    )
  )
)

result <- mc_match(test_module, "node_x", "node_y")
}
