% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/totals.R
\name{at_least_one}
\alias{at_least_one}
\title{Combine Probabilities Assuming Independence}
\usage{
at_least_one(
  mcmodule,
  mc_names,
  name = NULL,
  all_suffix = NULL,
  prefix = NULL,
  summary = TRUE
)
}
\arguments{
\item{mcmodule}{(mcmodule object). Module containing node list and data frames.}

\item{mc_names}{(character vector). Node names to combine.}

\item{name}{(character, optional). Custom name for combined node.
If NULL, auto-generated. Default: NULL.}

\item{all_suffix}{(character). Suffix for auto-generated node name.
Default: "all".}

\item{prefix}{(character, optional). Prefix for output node name. Default: NULL.}

\item{summary}{(logical). If TRUE, calculate summary statistics. Default: TRUE.}
}
\value{
Updated mcmodule with new combined probability node.
}
\description{
Combines probabilities of multiple independent events using the formula:
P(at least one) = 1 - (1-P(A)) * (1-P(B)) * ... Automatically matches
dimensions and keys.
}
\examples{
module <- list(
  node_list = list(
    p1 = list(
      mcnode = mcstoc(runif,
        min = mcdata(c(0.1, 0.2, 0.3), type = "0", nvariates = 3),
        max = mcdata(c(0.2, 0.3, 0.4), type = "0", nvariates = 3),
        nvariates = 3
      ),
      data_name = "data_x",
      keys = c("category")
    ),
    p2 = list(
      mcnode = mcstoc(runif,
        min = mcdata(c(0.5, 0.6, 0.7), type = "0", nvariates = 3),
        max = mcdata(c(0.6, 0.7, 0.8), type = "0", nvariates = 3),
        nvariates = 3
      ),
      data_name = "data_y",
      keys = c("category")
    )
  ),
  data = list(
    data_x = data.frame(
      category = c("A", "B", "C"),
      scenario_id = c("0", "0", "0")
    ),
    data_y = data.frame(
      category = c("B", "B", "B"),
      scenario_id = c("0", "1", "2")
    )
  )
)

module <- at_least_one(module, c("p1", "p2"), name = "p_combined")
print(module$node_list$p_combined$summary)
}
