% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_nodes.R
\name{manip_changes}
\alias{manip_changes}
\alias{add_changes}
\alias{delete_changes}
\alias{mutate_changes}
\alias{filter_changes}
\alias{select_changes}
\alias{collect_changes}
\alias{apply_changes}
\title{Modifying changes to nodes over time}
\usage{
add_changes(.data, changes)

delete_changes(.data)

mutate_changes(.data, ...)

filter_changes(.data, ..., .by = NULL)

select_changes(.data, ..., .by = NULL)

collect_changes(.data, time)

apply_changes(.data, time)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{changes}{A data frame of changes.
Ideally this will be in the form of "wave", "node", "var", and "value",
but there are internal routines from some otherwise common formats.
A data frame of composition change can be just two columns.}

\item{...}{Additional arguments.}

\item{.by}{An attribute name to join objects by.
By default, NULL.}

\item{time}{A time point or wave at which to present the network.}
}
\description{
These functions offer ways to modify data held about how nodes
change over time.
They include:
\itemize{
\item \code{add_changes()} adds a table of changes to the nodes of a network.
\item \code{mutate_changes()} can be used to update network changes.
\item \code{filter_changes()} is used to subset network changes.
\item \code{collect_changes()} is similar to \code{filter_changes()},
but collects the cumulative changes up to a time point.
\item \code{apply_changes()} applies the changes collected up to a time point
to a network, removing the changes.
}

An example of when this might be useful is to track change in the
composition of a network (when nodes are present or absent over time),
though the function can flexibly accommodate changes in other
nodal attributes.
}
\examples{
add_changes(ison_algebra, 
            data.frame(wave = 2, node = 1, var = "active", value = FALSE))
filter_changes(fict_starwars, node == "Anakin")
select_changes(fict_starwars, node)
collect_changes(fict_starwars, time = 3)
collect_changes(fict_starwars, time = 3)
}
\seealso{
\code{\link[=to_time]{to_time()}}
}
