% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmassess.R
\name{kmassess}
\alias{kmassess}
\alias{Assessment}
\title{Perform a probabilistic knowledge assessment}
\usage{
kmassess(r, pks, questioning, update, beta, eta, zeta0, zeta1, threshold)
}
\arguments{
\item{r}{Response pattern (binary vector)}

\item{pks}{Probabilistic knowledge structure: a data frame with a
probability distribution in the first columns and the structure
matrix in the subsequent columns.}

\item{questioning}{Questioning rule ("halfsplit" or "informative")}

\item{update}{Update rule ("Bayesian" or "multiplicative")}

\item{beta}{Careless error probabilities (vector)}

\item{eta}{Lucky guess probabilities (vector)}

\item{zeta0}{Vector of update parameters for wrong responses}

\item{zeta1}{Vector of update parameters for correct responses}

\item{threshold}{Probability threshold for stopping criterion}
}
\value{
A list with the following elements:
\describe{
\item{state}{Diagnosed knowledge state (binary vector)}
\item{probs}{Resultng probability distribution}
\item{queried}{Sequence of items used in the assessment (list)}
\item{qtime}{Average time for finding a question}
\item{utime}{Average time for updating the probabilities}
}
}
\description{
\code{kmassess} performs a probabilistic knowledge assessment for a given
response vector, knowledge structure, and BLIM parameters.
}
\details{
\code{kmassess} implements the stochastic assessment procedures according
to Doignon & Falmagne, 1999, chapter 10.

\code{kmassess} stops if the number of questions has reached twice the
number of items.
}
\section{Background}{

Doignon & Falmagne (1985, 1999) proposed knowledge space theory originally
with adaptive knowledge assessment in mind. The basic idea is to apply
prerequisite relationships between items for reducing the number of problems
to be posed to a learner in knowledge assessment.

Falmagne & Doignon (1988; Doignon & Falmange, 1999, chapte 10) proposed
a class of stochastic procdures for such adaptive assessment which take
into account that careless errors and lucky guesses may happen during the
assessment by estimating a probability distribution over the knowledge
structure. Such an assessment consists of three important parts
\itemize{
\item{Question rule}
\item{Update rule}
\item{Stopping criterion}
}

For the \strong{question rule,} they propose the \emph{halfsplit} and the \emph{infomrative}
rules, implemented in \code{kmassesshalfslit} and \code{kmassessinfomrative}.

For the \strong{update rule,} they again propose two possibilities there the
\emph{multiplicative rule} is a generalisation of the (classical) \emph{Bayesian
update rule} implemented here in \code{kmassessmultiplicative} and
\code{kmassessbayesian}, respectively.

As \strong{stopping criterion,} usually a threshold for the maximal probability for
one knowledge state is used. It is strongly recommended to keep this larger
than 0.5 in order to have one unequivocal resulting state (see also
Hockemeyer, 2002).
\subsection{Framework of assessment functions within the \pkg{kstMatrix} package:}{

The founding stones are the four aforementioned functions for finding
suitable questions and for updating the probability estimates, respectively.
They could also be used in an interactive system, e.g. a Shiny app, for
"real" adaptive assessment.

The remaining thee assessment functions serve for mere simulation of
adaptive assessment. \code{kmassess} takes, among others, a full response
pattern as parameter and takes the responses for the selected questions
from this vector. \code{kmsassess} is a simplified version where the
update parameters (beta and eta for Bayesian or zeta0 and zeta1 for
multiplicative update, respectively) are identical for all items whereas
they are item-specific in \code{kmassess}. Finally,
\code{kmassesssimulation} takes a whole data set, i.e. a collection of
response patterns, and does an assessment for each of these patterns. Its
result is a data frame which should be suitable for further statistical
evaluation, especially if it is called several times with variant
parameters (e.g., structures, update parameters, update and question rules).

Both, \code{kmsassess} and \code{kmassesssimulation} call \code{kmassess}.
}

\subsection{Problems}{

In rare cases \code{kmassess} may flip forth and back between probability
distributions resulting in an endless loop. Therefore, it stops after
twice the number of items delivering a \code{NULL} result.
}
}

\examples{
kmassess(c(1, 1, 0, 0),
         cbind(as.data.frame(as.matrix(rep(1/9.0, 9), ncol=1)), xpl$space),
         "halfsplit",
         "Bayesian",
         rep(0.3, 4),
         rep(0.2, 4),
         NULL,
         NULL,
         0.55
        )

}
\references{
Doignon, J.-P. & Falmagne, J.-C. (1985). Spaces for the assessment of
knowledge. \emph{International Journal of Man-Machne-Studies, 23,} 175-196.
\doi{10.1016/S0020-7373(85)80031-6}.

Doignon, J.-P. & Falmagne, J.-C. (1999). \emph{Knowledge Spaces.} Springer Verlag,
Berlin. \doi{10.1007/978-3-642-58625-5}.

Falmagne, J.-C. & Doignon, J.-P. (1988). A class of stochastic procedures
for the assessment of knowledge. \emph{British Journal of Mathematical and
Statistical Psychology, 41,} 1-23. \doi{10.1111/j.2044-8317.1988.tb00884.x}.

Hoxkemeyer, C. (2002). A comparison of non-deterministic procedures for the
adaptive assessment of knowledge. \emph{Psychlogische Beiträge, 44(4),} 495-503.
}
\seealso{
Other Knowledge assessment: 
\code{\link{kmassessbayesian}()},
\code{\link{kmassesshalfsplit}()},
\code{\link{kmassessinformative}()},
\code{\link{kmassessmentsimulation}()},
\code{\link{kmassessmultiplicative}()},
\code{\link{kmsassess}()}
}
\concept{Knowledge assessment}
