% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blocks_functions.R
\name{orbi_get_blocks_info}
\alias{orbi_get_blocks_info}
\title{Summarize blocks info}
\usage{
orbi_get_blocks_info(
  dataset,
  .by = c("uidx", "filename", "injection", "data_group", "block", "sample_name",
    "data_type", "segment")
)
}
\arguments{
\item{dataset}{An aggregated dataset or a data frame of peaks (i.e. works directly after \code{\link[=orbi_identify_isotopocules]{orbi_identify_isotopocules()}} as well as with a tibble from \link[=orbi_get_data]{orbi_get_data(peaks = everything())} or when reading from an IsoX file)}

\item{.by}{grouping columns for block info (akin to dplyr's \code{.by} parameter e.g. in \code{\link[dplyr:summarise]{dplyr::summarize()}}). If not set by the user, all columns in the parameter's default values are used, if present in the dataset.}
}
\value{
a block summary or if no blocks defined yet, an empty tibble (with warning)
}
\description{
This function provides an overview table \code{blocks_info} which shows information on blocks in the dataset (block number, sample name, data type, scan number and start time where a block starts, and scan number and end time where a block ends).
}
