\name{chess}
\alias{chess}
\alias{chess_table}
\alias{chess_maxp}
\alias{rock_paper_scissors}
\docType{data}
\title{Chess playing dataset}
\description{
A tally of wins and losses for games between three chess players:
Topalov, Anand, Karpov.
}
\usage{data(chess)}
\details{

  (there are three chess datasets in the package, documented at
  \code{interzonal.Rd} [the 1963 World championship], \code{kka.Rd}
  [Karpov-Kasparov-Anand dataset], and \code{chess.Rd}
  [rock-paper-scissors using Topalov-Anand-Karpov])
  
  This is a very simple dataset that can be used for illustration of
  \code{hyper2} idiom.
  
  The players are:
  \itemize{
    \item Grandmaster Veselin Topalov.  \acronym{FIDE} world
    champion 2005-2006; peak rating 2813
    \item Grandmaster Viswanathan Anand.  \acronym{FIDE} world
    champion 2000-2002, 2008; peak rating 2799
    \item Grandmaster Anatoly Karpov.  \acronym{FIDE} world
    champion 1993-1999; peak rating 2780
  }

  Observe that Topalov beats Anand, Anand beats Karpov, and Karpov beats
  Topalov (where \dQuote{beats} means \dQuote{wins more games than}).

  The games thus resemble a noisy version of \dQuote{rock paper scissors}.

  The likelihood function does not record who played white; see
  \code{karpov_kasparov_anand} for such a dataset.

These objects can be generated by running script
\code{inst/rock_paper_scissors.Rmd}, which includes some further
discussion and technical documentation and creates file \code{chess.rda}
which resides in the \code{data/} directory.


File \code{inst/ternaryplot_hyper2.Rmd} gives an example showing the
\code{chess} likelihood function that uses
\code{Ternary::ternaryPlot()}.


}
\references{
  \itemize{
    \item \url{https://en.chessbase.com/}
  }
}
\seealso{\code{\link{karpov_kasparov_anand}}}
\examples{
data(chess)
maxp(chess)

 mgf(chess,c(Anand=2),tol = 0.1)  # tolerance for speed

}
\keyword{datasets}
