% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataHandling.R
\name{refreshTime}
\alias{refreshTime}
\title{Synchronize (multiple) irregular timeseries by refresh time}
\usage{
refreshTime(pData, sort = FALSE, criterion = "squared duration")
}
\arguments{
\item{pData}{a list. Each list-item contains an \code{xts} or a \code{data.table} object (with first column DT (datetime)) containing the original time series (one day only and typically a price series).}

\item{sort}{logical determining whether to sort the index based on a criterion (will only sort descending; i.e., most liquid first). Default is \code{FALSE}.}

\item{criterion}{character determining which criterion used. Currently supports \code{"squared duration"} and \code{"duration"}. Default is \code{"squared duration"}.}
}
\value{
An \code{xts} or \code{data.table} object containing the synchronized time series - depending on the input.
}
\description{
This function implements the refresh time synchronization scheme proposed by Harris et al. (1995). 
It picks the so-called refresh times at which all assets have traded at least once since the last refresh time point. 
For example, the first refresh time corresponds to the first time at which all stocks have traded.
The subsequent refresh time is defined as the first time when all stocks have traded again.
This process is repeated until the end of one time series is reached.
}
\examples{
# Suppose irregular timepoints:
start <- as.POSIXct("2010-01-01 09:30:00")
ta <- start + c(1,2,4,5,9)
tb <- start + c(1,3,6,7,8,9,10,11)

# Yielding the following timeseries:
a <- xts::as.xts(1:length(ta), order.by = ta)
b <- xts::as.xts(1:length(tb), order.by = tb)

# Calculate the synchronized timeseries:
refreshTime(list(a,b))

}
\references{
Harris, F., T. McInish, Shoesmith, G., and Wood, R. (1995). Cointegration, error correction, and price discovery on informationally linked security markets. \emph{Journal of Financial and Quantitative Analysis}, 30, 563-581.
}
\author{
Jonathan Cornelissen, Kris Boudt, Onno Kleen, and Emil Sjoerup.
}
\keyword{data}
\keyword{manipulation}
