% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_color_box.R
\name{gt_color_box}
\alias{gt_color_box}
\title{Add a small color box relative to the cell value.}
\usage{
gt_color_box(
  gt_object,
  columns,
  palette = NULL,
  ...,
  domain = NULL,
  width = 70,
  font_weight = "bold"
)
}
\arguments{
\item{gt_object}{An existing gt table object of class \code{gt_tbl}}

\item{columns}{The columns wherein changes to cell data colors should occur.}

\item{palette}{The colours or colour function that values will be mapped to. Can be a character vector (eg \code{c("white", "red")} or hex colors) or a named palette from the \code{{paletteer}} package in the \code{package::palette_name} structure. Note that \code{'pff'} will fill in a blue -> green -> yellow -> orange -> red palette.}

\item{...}{Additional arguments passed to \code{scales::label_number()}, primarily used to format the numbers inside the color box}

\item{domain}{The possible values that can be mapped. This should be a simple numeric range (e.g. \code{c(0, 100)})}

\item{width}{The width of the entire coloring area in pixels.}

\item{font_weight}{A string indicating the font weight, defaults to \code{"bold"}, change to \code{"normal"} for default weight.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Create \code{PFF}-style colorboxes in a \code{gt} table.
Note that rather than using \code{gt::fmt_} functions on this column, you can send
numeric formatting arguments via \code{...}. All arguments should be named
and are passed to \code{scales::label_number()}.
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(gt)
test_data <- dplyr::tibble(x = letters[1:10],
                    y = seq(100, 10, by = -10),
                    z = seq(10, 100, by = 10))
color_box_tab <- test_data \%>\%
  gt() \%>\%
  gt_color_box(columns = y, domain = 0:100, palette = "ggsci::blue_material") \%>\%
  gt_color_box(columns = z, domain = 0:100,
               palette = c("purple", "lightgrey", "green"))
}\if{html}{\out{</div>}}
}

\section{Figures}{

\if{html}{\figure{color_box.png}{options: width=30\%}}
}

\section{Function ID}{

4-3
}

\seealso{
Other Colors: 
\code{\link{gt_color_rows}()},
\code{\link{gt_hulk_col_numeric}()}
}
\concept{Colors}
