% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco-get-metadata.R
\name{gisco_get_metadata}
\alias{gisco_get_metadata}
\title{Get metadata}
\source{
\url{https://gisco-services.ec.europa.eu/distribution/v2/}.
}
\usage{
gisco_get_metadata(
  id = c("nuts", "countries", "urban_audit"),
  year = 2024,
  verbose = FALSE
)
}
\arguments{
\item{id}{character string. Select the unit type to be downloaded. Accepted
values are \code{"nuts"}, \code{"countries"} or \code{"urban_audit"}.}

\item{year}{character string or number. Release year of the metadata.}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}
}
\value{
A \link[tibble:tbl_df-class]{tibble}.
}
\description{
Get a table with the names and ids of administrative of statistical units.
}
\examples{
\dontshow{if (gisco_check_access()) withAutoprint(\{ # examplesIf}
cities <- gisco_get_metadata(id = "urban_audit", year = 2020)

cities
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=gisco_get_nuts]{gisco_get_nuts()}}, \code{\link[=gisco_get_countries]{gisco_get_countries()}}, \code{\link[=gisco_get_urban_audit]{gisco_get_urban_audit()}}.

Other database utils:
\code{\link{gisco_db}},
\code{\link{gisco_get_cached_db}()}
}
\concept{database}
