% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/padding.R
\name{get_padding_from_elements}
\alias{get_padding_from_elements}
\title{Calculate length of padding from plot elements}
\usage{
get_padding_from_elements(
  gg_plot,
  elements_t,
  elements_r,
  elements_b,
  elements_l
)
}
\arguments{
\item{gg_plot}{A ggplot2 object.}

\item{elements_t}{character vector with names of elements to consider for padding at the \emph{top}}

\item{elements_r}{character vector with names of elements to consider for padding on the \emph{right}}

\item{elements_b}{character vector with names of elements to consider for padding at the \emph{bottom}}

\item{elements_l}{character vector with names of elements to consider for padding on the \emph{left}}
}
\value{
A vector \code{grid::unit}s of paddings for \code{t}, \code{r}, \code{b}, \code{l} (in pt)
}
\description{
To prevent overlap with panel borders or axis lines, annotations are clipped
to a viewport that is reduced in size by the width of these lines.
They depend on the current plot theme.
}
\seealso{
\code{\link{uninfinite_coord}} for construction of the complete
replaced coordinate.
}
