% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_automap.R, R/stat_automap_coords.R
\docType{data}
\name{stat_automap}
\alias{stat_automap}
\alias{StatAutomap}
\alias{StatAutomapCoords}
\title{Attach spatial data with 'cartographer'}
\usage{
stat_automap(
  mapping = NULL,
  data = NULL,
  geom = "sf",
  position = "identity",
  ...,
  feature_type = NA,
  na.rm = TRUE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping, data, geom, position, na.rm, show.legend, inherit.aes, ...}{See \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}}.}

\item{feature_type}{Type of map feature. See \code{\link[cartographer:feature_types]{feature_types()}} for a list of
registered types. If \code{NA}, the type is guessed based on the values in
\code{feature_names}.}
}
\value{
A ggplot layer
}
\description{
Use 'cartographer' to attach a spatial column to the data based
on place names in another column. The result can then be used by
\code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}} or \code{\link[ggmapinset:geom_sf_inset]{ggmapinset::geom_sf_inset()}}.
}
\section{Computed variables}{

\describe{
\item{geometry}{\code{sf} geometry column}
\item{...}{limits as computed by \code{\link[ggplot2:ggsf]{ggplot2::stat_sf()}}}
}
}

\examples{
library(ggplot2)

events <- data.frame(
  county = c("Mecklenburg", "Carteret", "Moore", "Caldwell"),
  proportion_A = c(0.1, 0.8, 0.0, 0.6)
)

ggplot(events, aes(location = county)) +
  geom_sf(aes(fill = proportion_A), stat = "automap")

ggplot(events, aes(location = county)) +
  stat_automap(aes(fill = proportion_A)) +
  coord_automap(feature_type = "sf.nc")
}
\keyword{datasets}
