% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-crop-analysis.R
\name{create_crop_mask}
\alias{create_crop_mask}
\title{Create crop mask from CDL data}
\usage{
create_crop_mask(
  cdl_data,
  crop_codes,
  region_boundary = NULL,
  mask_type = "binary"
)
}
\arguments{
\item{cdl_data}{CDL raster data (file path or SpatRaster)}

\item{crop_codes}{Vector of CDL codes or crop names}

\item{region_boundary}{Optional region boundary for clipping}

\item{mask_type}{Type of mask: "binary" (1/0) or "preserve" (keep original codes)}
}
\value{
SpatRaster with crop mask
}
\description{
Create binary or classified crop mask from USDA CDL data for specified crops.
Fixed to handle terra operations properly.
}
\examples{
\dontrun{
# These examples require actual CDL data files
# Create corn mask
corn_mask <- create_crop_mask("cdl_2023.tif", "corn", "Iowa")

# Create grain crops mask
grain_mask <- create_crop_mask(cdl_raster, "grains", mask_type = "preserve")
}

\donttest{
# Example with mock data (this can run)
mock_cdl <- terra::rast(nrows = 5, ncols = 5, crs = "EPSG:4326")
terra::values(mock_cdl) <- c(1, 1, 5, 5, 24, 1, 5, 5, 24, 24,
                            1, 1, 5, 24, 24, 5, 5, 24, 24, 1,
                            1, 5, 5, 24, 1)  # corn, soy, wheat

# Create corn mask from mock data
corn_mask <- create_crop_mask(mock_cdl, "corn")
print(terra::values(corn_mask))  # Should show 1s and 0s
}

}
