% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova_varcomps.R
\name{ss_calcs}
\alias{ss_calcs}
\title{ANOVA Sum of Squares Calculations}
\usage{
ss_calcs(data, part, operator, meas)
}
\arguments{
\item{data}{An R dataframe or tibble containing the required identifier and measurement columns.}

\item{part}{A column in data specifying the unique ID of the part being measured. The column should be a character or
factor vector.}

\item{operator}{A column in data specifying the operator for the recorded measurement. The column should be a
character or factor vector.}

\item{meas}{A column in data where the measurement value is recorded. The column must be numeric and contain no
missing or infinite values.}
}
\value{
A list of numeric values for the sum of squares error for operator, part, equipment, operator and part interaction, and total error.
}
\description{
ANOVA Sum of Squares Calculations
}
\examples{
data = data.frame(
SN = c(
'SerialNumber_01',
'SerialNumber_01',
'SerialNumber_02',
'SerialNumber_02',
'SerialNumber_01',
'SerialNumber_01',
'SerialNumber_02',
'SerialNumber_02'),

Operator = c(
'Operator_01',
'Operator_01',
'Operator_01',
'Operator_01',
'Operator_02',
'Operator_02',
'Operator_02',
'Operator_02'),

Measure = c(
0.0172,
0.0177,
0.0155,
0.0159,
0.0174,
0.0181,
0.0152,
0.0176))

ss_calcs(data, part = 'SN', operator = 'Operator', meas = 'Measure')
}
