% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transactions.R
\name{db_transaction}
\alias{db_transaction}
\title{Execute code within a database transaction}
\usage{
db_transaction(conn, code)
}
\arguments{
\item{conn}{Database connection}

\item{code}{Expression or code block to execute within the transaction}
}
\value{
The result of the code expression
}
\description{
Wraps code execution in a database transaction with automatic
commit on success and rollback on error. This ensures atomicity
of multiple database operations.
}
\details{
The function automatically:
\itemize{
\item Begins a transaction with \code{DBI::dbBegin()}
\item Executes the provided code
\item Commits the transaction on success with \code{DBI::dbCommit()}
\item Rolls back the transaction on error with \code{DBI::dbRollback()}
}

Transactions are essential for maintaining data integrity when performing
multiple related operations. If any operation fails, all changes are rolled back.
}
\examples{
\donttest{
if (FALSE) {
conn <- db_connect("postgres")

# Basic transaction
db_transaction(conn, {
  DBI::dbExecute(conn, "INSERT INTO users (name, age) VALUES ('Alice', 30)")
  DBI::dbExecute(conn, "INSERT INTO users (name, age) VALUES ('Bob', 25)")
})

# Transaction with error handling - auto-rollback on error
tryCatch({
  db_transaction(conn, {
    DBI::dbExecute(conn, "INSERT INTO users (name) VALUES ('Alice')")
    stop("Something went wrong")  # This will trigger rollback
  })
}, error = function(e) {
  message("Transaction failed: ", e$message)
})

DBI::dbDisconnect(conn)
}
}

}
