% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{dist_moments}
\alias{dist_moments}
\title{Compute Moments of a Probability Distribution}
\usage{
dist_moments(pdf, cdf, support = c(0, Inf), params = list())
}
\arguments{
\item{pdf}{Function for the probability density function (PDF).
Must accept \code{x} as the first argument and parameters as a named list.}

\item{cdf}{Function for the cumulative distribution function (CDF).
Must accept \code{x} as the first argument and parameters as a named list.}

\item{support}{Numeric vector of length 2. The support (lower and upper limits) of the distribution.}

\item{params}{Named list of parameters to pass to \code{pdf} and \code{cdf}.}
}
\value{
A data frame with Mean, Variance, Skewness, Kurtosis, Median, and Mode.
}
\description{
Calculates mean, variance, skewness, kurtosis, median, and mode
for a given probability distribution defined by PDF and CDF.
}
\examples{
# Generalized Exponential Distribution
pdf_ge <- function(x, alpha, lambda) {
  alpha * lambda * (1 - exp(-lambda * x))^(alpha - 1) * exp(-lambda * x)
}
cdf_ge <- function(x, alpha, lambda) {
  (1 - exp(-lambda * x))^alpha
}
dist_moments(pdf_ge, cdf_ge, support = c(0, Inf), params = list(alpha = 2, lambda = 3))

# Exponentiated Weibull Distribution
pdf_expweibull <- function(x, a, b, c){
  a * b * c * exp(-(b*x)^c) * (b*x)^(c-1) * (1 - exp(-(b*x)^c))^(a-1)
}
cdf_expweibull <- function(x, a, b, c){
  (1 - exp(-(b*x)^c))^a
}
dist_moments(pdf_expweibull, cdf_expweibull, support = c(0, Inf),
             params = list(a = 1.0, b = 1.4, c = 2.3))

}
