% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guard_beecoptor.R
\name{guard_beeceptor}
\alias{guard_beeceptor}
\alias{guard_beeceptor_github}
\alias{guard_beeceptor_google}
\title{Guard using the mock OAuth servers provided by Beeceptor}
\usage{
guard_beeceptor_github(
  redirect_url,
  client_id = "MOCK_CLIENT",
  ...,
  name = "beeceptor_github"
)

guard_beeceptor_google(
  redirect_url,
  client_id = "MOCK_CLIENT",
  ...,
  name = "beeceptor_google"
)
}
\arguments{
\item{redirect_url}{The URL the authorization server should redirect to
following a successful authorization. Must be equivalent to one provided
when registering your application}

\item{client_id}{The ID issued by the authorization server when
registering your application}

\item{...}{
  Arguments passed on to \code{\link[=guard_oauth2]{guard_oauth2}}
  \describe{
    \item{\code{token_url}}{The URL to the authorization servers token endpoint}
    \item{\code{client_secret}}{The secret issued by the authorization server when
registering your application. Do NOT store this in plain text}
    \item{\code{auth_url}}{The URL to redirect the user to when requesting
authorization (only needed for \code{grant_type = "authorization_code"})}
    \item{\code{grant_type}}{The type of authorization scheme to use, either
\code{"authorization_code"} or \code{"password"}}
    \item{\code{oauth_scopes}}{Optional character vector of scopes to request the
user to grant you during authorization. These will \emph{not} influence the
scopes granted by the \code{validate} function and fireproof scoping. If named,
the names are taken as scopes and the elements as descriptions of the scopes,
e.g. given a scope, \code{read}, it can either be provided as \code{c("read")} or
\code{c(read = "Grant read access")}}
    \item{\code{validate}}{Function to validate the user once logged in. It will be
called with a single argument \code{info}, which gets the information of the user
as provided by the \code{user_info} function in the. By default it returns \code{TRUE}
on everything meaning that anyone who can log in with the provider will
be accepted, but you can provide a different function to e.g. restrict
access to certain user names etc. If the function returns a
character vector it is considered to be authenticated and the return value
will be understood as scopes the user is granted.}
    \item{\code{redirect_path}}{The path that should capture redirects after
successful authorization. By default this is derived from \code{redirect_url}
by removing the domain part of the url, but if for some reason this
doesn't yields the correct result for your server setup you can overwrite
it here.}
    \item{\code{on_auth}}{A function which will handle the result of a successful
authorization. It will be called with four arguments: \code{request}, \code{response},
\code{session_state}, and \code{server}. The first contains the current request
being responded to, the second is the response being send back, the third
is a list recording the state of the original request which initiated the
authorization (containing \code{method}, \code{url}, \code{headers}, and \code{body} fields
with information from the original request). By default it will use
\link{replay_request} to internally replay the original request and send back
the response.}
    \item{\code{user_info}}{A function to extract user information from the
access token. It is called with a single argument: \code{token_info} which is the
access token information returned by the OAuth 2 server after a successful
authentication. The function should return a new \link[=new_user_info]{user_info}
list.}
    \item{\code{service_params}}{A named list of additional query params to add to
the url when constructing the authorization url in the
\code{"authorization_code"} grant type}
    \item{\code{scopes_delim}}{The separator of the scopes as returned by the service.
The default \code{" "} is the spec recommendation but some services \emph{cough}
github \emph{cough} are non-compliant}
  }}

\item{name}{The name of the guard}
}
\value{
A \link{GuardOAuth2} object
}
\description{
These two functions sets up mock OAuth 2.0 guards based on tools
provided by
\href{https://app.beeceptor.com/mock-server/oauth-mock}{Beeceptor}. They should
obviously not be used for production because they allow anyone to be
authenticated, but they can be used while testing your authentication setup.
}
\examples{
beeceptor <- guard_beeceptor_github(
  redirect_url = "https://example.com/auth"
)

# Add it to a fireproof plugin
fp <- Fireproof$new()
fp$add_guard(beeceptor, "beeceptor_auth")

# Use it in an endpoint
fp$add_auth("get", "/*", beeceptor_auth)

}
