test_that("data-decomposition.R works on ATHABASCA RIVER (07BE001)", {

	df <- data_local("CAN-07BE001.csv")

	decomposed <- data_decomposition(df$max, df$year, S00)
	expect_equal(decomposed, df$max)

	decomposed <- data_decomposition(df$max, df$year, S10)
	expect_equal(decomposed, c(
		1654.8837, 3073.7209, 2742.5581, 2061.3953, 2470.2326, 1449.0698, 1007.9070, 2476.7442,
		1455.5814,  897.4186, 1843.2558, 1522.0930, 1870.9302, 1439.7674, 2198.6047, 2167.4419,
		1116.2791, 1745.1163,  291.9535, 1015.8140, 1204.6512, 1593.4884, 1932.3256, 1651.1628,
		2030.0000, 4758.8372,  898.6744, 1576.5116, 1945.3488, 3594.1860,  973.0233, 1511.8605,
		1740.6977, 2369.5349, 1768.3721, 5377.2093, 2166.0465, 1654.8837, 1093.7209, 2202.5581,
		1651.3953, 2740.2326, 1019.0698, 1477.9070, 1516.7442, 1525.5814, 3434.4186, 1663.2558,
		1552.0930, 1210.9302, 2919.7674, 1448.6047, 4387.4419, 3286.2791, 1755.1163, 2433.9535,
		1702.7907, 1541.6279, 2250.4651, 2199.3023, 2138.1395, 4096.9767, 1145.8140, 3324.6512,
		1453.4884, 1292.3256, 1351.1628, 4300.0000, 1938.8372, 1477.6744, 2216.5116, 2585.3488,
		1764.1860,  913.0233,  810.8605, 1530.6977, 2049.5349, 2458.3721, 2767.2093, 1496.0465,
		1984.8837, 1393.7209, 2462.5581, 1011.3953, 1250.2326, 1679.0698, 1887.9070, 1036.7442,
		2165.5814, 1374.4186, 1333.2558,  778.0930, 3680.9302, 2999.7674, 2048.6047, 1237.4419,
	 	 886.2791, 1085.1163, 2163.9535, 1722.7907, 2571.6279, 3760.4651
	), tol = 1e-4)

	decomposed <- data_decomposition(df$max, df$year, S01)
	expect_equal(decomposed, c(
		1674.9205, 3074.9329, 2748.9377, 2079.3326, 2482.1749, 1480.4503, 1049.5381, 2490.6185,
		1491.9412,  947.9455, 1873.9490, 1561.9025, 1903.5241, 1484.9727, 2224.7928, 2195.4535,
		1176.0103, 1787.8352,  381.3997, 1097.1945, 1280.7355, 1655.9294, 1982.4184, 1714.1835,
		2078.2544, 4688.8584,  999.6091, 1648.6659, 2001.8246, 3573.4761, 1078.8932, 1593.1722,
		1812.0373, 2409.9660, 1840.9188, 5259.3176, 2219.6846, 1737.5516, 1209.1604, 2256.8803,
		1738.4376, 2764.7640, 1146.5770, 1579.6074, 1617.5980, 1627.3852, 3416.9459, 1759.2012,
		1656.6327, 1339.4421, 2935.7216, 1564.5248, 4302.9888, 3277.3671, 1854.0436, 2485.6691,
		1808.0154, 1659.9484, 2317.7152, 2271.1960, 2215.5249, 4024.9322, 1302.0420, 3311.5858,
		1588.8395, 1442.1140, 1497.8149, 4206.3413, 2039.9325, 1618.4699, 2296.2292, 2634.3427,
		1884.6156, 1108.9283, 1017.7097, 1675.5205, 2149.1456, 2521.8532, 2803.0134, 1649.6649,
		2094.3277, 1559.8109, 2528.6339, 1217.1268, 1434.6957, 1823.3267, 2012.8711, 1247.2282,
		2264.9043, 1554.4027, 1518.9246, 1022.2361, 3626.8790, 3016.2880, 2165.2036, 1440.8732,
		1128.7873, 1308.1180, 2271.7292, 1879.5707, 2636.1813, 3693.6996
    ), tol = 1e-4)

	decomposed <- data_decomposition(df$max, df$year, S11)
	expect_equal(decomposed, c(
		1658.8103, 3058.2798, 2730.9435, 2059.7872, 2461.6651, 1458.1330, 1025.7219, 2466.5664,
		1465.9896,  920.3733, 1845.8833, 1532.3882, 1873.1030, 1452.9930, 2192.2990, 2161.7611,
		1140.1392, 1751.3894,  342.2899, 1050.4986, 1233.0991, 1607.6257, 1933.4067, 1663.6449,
		2027.0896, 4640.4196,  944.5355, 1593.4253, 1945.9942, 3519.0414, 1019.2838, 1533.2648,
		1751.3633, 2349.1996, 1778.0367, 5201.4629, 2155.2475, 1671.1070, 1140.5924, 2189.1934,
		1668.6342, 2695.8857, 1073.3485, 1506.1369, 1543.0921, 1551.7888, 3344.0777, 1681.6758,
		1577.7805, 1258.7787, 2857.5685, 1482.1620, 4225.9054, 3196.8512, 1769.0840, 2401.1550,
		1720.7783, 1571.2633, 2229.5989, 2181.9002, 2125.0252, 3938.0805, 1207.0190, 3220.8289,
		1492.4228, 1344.2267, 1399.0071, 4113.9980, 1940.5108, 1516.8006, 2195.4451, 2533.5008,
		1780.5503, 1001.5205,  908.9615, 1567.6892, 2041.7105, 2414.5334, 2695.5481, 1537.5750,
		1982.6045, 1445.3552, 2416.2610, 1099.4805, 1316.7177, 1705.5976, 1894.7506, 1125.5133,
		2145.6079, 1431.6677, 1395.0428,  895.6019, 3508.3497, 2894.6386, 2039.5436, 1311.6118,
	 	 997.3788, 1176.3407, 2142.4806, 1747.8805, 2506.3204, 3566.8446
    ), tol = 1e-4)

})


test_that("data-decomposition.R works on KOOTENAI RIVER (08NH021)", {

	df <- data_local("CAN-08NH021.csv")

	decomposed <- data_decomposition(df$max, df$year, S10)
	expect_equal(decomposed, c(
		2738.0000, 2081.8571, 2145.7143, 1899.5714, 2633.4286, 3097.2857, 3001.1429, 2455.0000,
        2188.8571, 2052.7143, 3106.5714, 1990.4286, 2104.2857, 1668.1429, 2902.0000, 2525.8571,
        1552.7143, 2383.5714, 2997.4286, 3231.2857, 4205.1429, 3139.0000, 3282.8571, 3216.7143,
        2740.5714, 2974.4286, 3638.2857, 3272.1429, 4006.0000, 3119.8571, 3103.7143, 3457.5714,
        3021.4286, 4155.2857, 2659.1429, 2683.0000, 3526.8571, 3040.7143, 3384.5714, 3708.4286,
        3072.2857, 3546.1429, 2830.0000, 3533.8571, 2697.7143, 1821.5714, 2585.4286, 2169.2857,
        2313.1429, 1758.0000, 1910.8571, 1856.7143, 2158.5714, 2382.4286, 2416.2857, 2067.1429,
        1875.0000, 2207.8571, 2185.7143, 2114.5714, 1967.4286, 2187.2857, 2347.1429, 2781.0000,
        2067.8571, 2092.7143, 2041.5714, 2556.4286, 2920.2857, 3084.1429, 2688.0000, 2771.8571,
        2415.7143, 1872.5714, 2833.4286, 2415.2857, 2313.1429, 2401.0000, 3248.8571, 2522.7143,
        3116.5714, 2550.4286, 2874.2857, 2998.1429, 3262.0000, 3125.8571, 2959.7143, 2733.5714,
        2817.4286, 2951.2857, 2975.1429
	), tol = 1e-4)

	decomposed <- data_decomposition(df$max, df$year, S01)
	expect_equal(decomposed, c(
		3285.4744, 2503.0477, 2562.1839, 2253.3776, 3113.3915, 3658.9715, 3532.9385, 2856.7756,
    	2515.5683, 2330.5160, 3621.4723, 2215.8483, 2339.8680, 1768.8937, 3319.4387, 2824.3895,
    	1551.5993, 2607.6926, 3393.9021, 3689.9212, 4971.9132, 3545.9539, 3728.0809, 3628.2690,
    	2967.7733, 3273.3118, 4178.0894, 3660.6259, 4679.4691, 3423.0601, 3387.1087, 3881.3635,
    	3241.3528, 4877.4762, 2680.4970, 2696.6664, 3934.2662, 3194.9758, 3699.4743, 4181.3830,
    	3196.1186, 3913.9522, 2785.8902, 3873.8983, 2536.7890, 1113.7550, 2311.6905, 1610.9722,
    	1816.6683,  870.0054, 1087.8897,  961.3350, 1436.6311, 1786.7674, 1815.0065, 1176.4459,
    	 802.3714, 1352.8565, 1277.8866, 1112.9853,  806.3823, 1169.6700, 1428.3695, 2206.2346,
    	 825.8639,  830.4951,  688.3543, 1648.0725, 2329.5143, 2626.5521, 1802.8607, 1937.9413,
    	1171.8003,    1.0000, 1961.8411, 1039.3723,  774.4740,  915.8048, 2727.3919, 1088.3242,
    	2373.6446, 1055.4862, 1750.5470, 1997.3188, 2579.3923, 2223.2162, 1785.9055, 1191.1843,
    	1347.6407, 1633.2986, 1647.4126
 	), tol = 1e-4)

	decomposed <- data_decomposition(df$max, df$year, S11)
	expect_equal(decomposed, c(
    	2745.7520, 1986.7403, 2057.2265, 1765.7994, 2624.0364, 3172.3982, 3060.7418, 2409.5491,
    	2087.8355, 1919.7419, 3197.5419, 1834.7326, 1969.9412, 1425.9181, 2954.7645, 2485.2764,
    	1258.1808, 2302.5772, 3082.8220, 3385.1131, 4645.8112, 3273.8182, 3465.2885, 3383.1687,
    	2757.9373, 3069.5106, 3960.6642, 3475.4315, 4475.3921, 3277.7318, 3259.3675, 3752.1509,
    	3152.3637, 4743.1162, 2647.8701, 2681.4626, 3886.7758, 3195.7871, 3697.0638, 4176.0355,
    	3252.6282, 3956.8318, 2899.9655, 3956.2598, 2703.3378, 1371.7703, 2531.6849, 1888.9117,
    	2106.5342, 1233.7518, 1463.9347, 1368.8692, 1841.8712, 2196.2992, 2247.5529, 1672.8126,
    	1348.1055, 1890.8865, 1847.5501, 1720.8018, 1462.6987, 1830.0098, 2099.5140, 2851.1305,
    	1598.9060, 1633.9288, 1533.7059, 2451.9274, 3111.3165, 3415.3691, 2689.1292, 2845.5763,
    	2176.7766, 1141.0432, 2967.8029, 2162.0924, 1958.0537, 2124.2906, 3803.7141, 2357.8341,
    	3557.0760, 2408.1842, 3073.8760, 3335.7732, 3897.4707, 3620.1595, 3272.8623, 2788.3845,
    	2973.1566, 3272.4465, 3331.9526
 	), tol = 1e-4)

})


test_that("data-decomposition.R works on BOW RIVER (05BB001)", {

	df <- data_local("CAN-05BB001.csv")

	decomposed <- data_decomposition(df$max, df$year, S10)
	expect_equal(decomposed, c(
    	318.3941,  234.8823,  269.3706,  179.8588,  238.3470,  220.8353,  243.3235,  316.8117,
    	182.3000,  353.7882,  194.2764,  257.7647,  181.2529,  219.7411,  388.2294,  178.7176,
    	224.2058,  142.6941,  234.1823,  302.6705,  229.1588,  277.6470,  202.1352,  294.6235,
    	327.1117,  285.5999,  214.0882,  236.5764,  166.0646,  238.5529,  197.0411,  223.5293,
    	146.0176,  186.5058,  229.9940,  179.4823,  147.9705,  226.4587,  189.9470,  315.4352,
    	144.9234,  310.4117,  267.8999,  180.3882,  285.8764,  312.3646,  272.8529,  284.3411,
    	179.8293,  219.3176,  240.8058,  211.2940,  295.7823,  214.2705,  213.7587,  277.2470,
    	320.7352,  257.2234,  307.7117,  224.1999,  236.6881,  189.1764,  233.6646,  346.1528,
    	250.6411,  353.1293,  180.6175,  228.1058,  244.5940,  227.0822,  188.5705,  229.0587,
    	266.5469,  232.0352,  195.5234,  261.0116,  201.4999,  354.9881,  188.4763,  286.9646,
    	251.4528,  282.9410,  286.4293,  175.9175,  173.4057,  192.8940,  309.3822,  277.8704,
    	260.3587,  180.8469,  253.3351,  201.8234,  214.3116,  275.7998,  214.2881,  212.7763,
    	218.2645,  219.7528,  350.2410,  215.7292,  196.2175,  191.7057,  233.1939,  386.6822,
    	521.1704,  233.6586,  207.1469,  163.6351,  256.6116
	), tol = 1e-4)

	decomposed <- data_decomposition(df$max, df$year, S01)
	expect_equal(decomposed, c(
    	314.1597,  230.0312,  264.0995,  173.9204,  232.0451,  214.0047,  236.0626,  309.2704,
    	173.8871,  345.4173,  184.9103,  248.1254,  170.8495,  208.9882,  377.6622,  166.8111,
    	211.9997,  129.6273,  221.0421,  289.3763,  215.0148,  263.2670,  186.8641,  279.3744,
    	311.5709,  269.3385,  196.9077,  219.0436,  147.5851,  220.0527,  177.7674,  203.9435,
    	125.3820,  165.6611,  208.9768,  157.5831,  125.3212,  203.9349,  166.6286,  292.6727,
    	120.2174,  286.6483,  243.2767,  154.4793,  260.4458,  286.7007,  246.3276,  257.4417,
    	151.3987,  190.7853,  211.9992,  181.6830,  266.5781,  183.6941,  182.6780,  246.3818,
    	289.8793,  225.1501,  275.7417,  190.7479,  202.8898,  154.2968,  198.8366,  312.2541,
    	215.0376,  318.3676,  143.1006,  190.7178,  206.9312,  188.6828,  149.1355,  189.6886,
    	227.2132,  191.7097,  154.1643,  220.1175,  159.2189,  314.5320,  144.9852,  244.4961,
    	207.9360,  239.4280,  242.4811,  129.6821,  126.6182,  145.9188,  263.8553,  231.3213,
    	213.0159,  131.6293,  204.8761,  151.9547,  164.1586,  226.2514,  163.1234,  161.0779,
    	166.1618,  167.1725,  299.6289,  162.0609,  141.6657,  136.5557,  178.3491,  334.3817,
    	471.0889,  177.3110,  149.7539,  104.8372,  198.7262
 	), tol = 1e-4)

	decomposed <- data_decomposition(df$max, df$year, S11)
	expect_equal(decomposed, c(
		318.6228,  234.8556,  269.4688,  179.6044,  238.3274,  220.7315,  243.3260,  317.2108,
    	181.9529,  354.4619,  193.9651,  257.8655,  180.8162,  219.5695,  389.3594,  178.1974,
    	224.0483,  141.8133,  234.1032,  303.2376,  229.0245,  278.0007,  201.7077,  295.1852,
    	328.0547,  286.0931,  213.7468,  236.4999,  165.1002,  238.4976,  196.4343,  223.2669,
    	144.6680,  185.7012,  229.8062,  178.5336,  146.5172,  226.2022,  189.1001,  316.6228,
    	143.2878,  311.5639,  268.3360,  179.2800,  286.6551,  313.6468,  273.4168,  285.1353,
    	178.6016,  218.8511,  240.7648,  210.6464,  296.8878,  213.6640,  213.1312,  278.0016,
    	322.4708,  257.5490,  309.2026,  223.7650,  236.5425,  187.8866,  233.4409,  348.7088,
    	250.8369,  355.9356,  179.0125,  227.7205,  244.6406,  226.6591,  187.0939,  228.6789,
    	267.2089,  231.7298,  194.1689,  261.5384,  200.2871,  358.3182,  186.8429,  288.3062,
    	251.7178,  284.1890,  287.8013,  173.7874,  171.1709,  191.2686,  311.5717,  279.0357,
    	260.9477,  178.7407,  253.6956,  200.4004,  213.3117,  276.9672,  213.2668,  211.6902,
    	217.3678,  218.9021,  354.2379,  214.7107,  194.4490,  189.7476,  232.8212,  392.2950,
    	532.1318,  233.2939,  205.7155,  160.4298,  257.1791
 	), tol = 1e-4)

})


test_that("data-decomposition.R works on CHILLIWACK RIVER (08MH016)", {

	df <- data_local("CAN-08MH016.csv")

	decomposed <- data_decomposition(df$max, df$year, S10)
	expect_equal(decomposed, c(
    	 59.8854,   71.3484,   75.7114,   31.6744,   58.7373,   62.0003,   49.9633,   42.2263,
		 41.7892,   79.8522,   81.7152,   70.4782,   83.4411,   63.2041,   61.5671,   55.8300,
		 55.3930,   47.3560,   60.5190,   41.3819,   60.7449,   30.1079,   47.1709,   66.3338, 
		 57.9968,   91.2598,   78.9228,   88.1857,   54.9266,   67.7895,   55.7525,   47.7155,
		 76.7785,   41.2414,   45.0044,   64.9674,   44.4304,   51.3933,   84.9563,   76.9193,
		 64.8823,   50.2452,   62.0082,   97.2712,   37.4341,   97.9971,   83.0601,   57.7231,
		 31.4860,   48.3490,   82.1120,  107.1750,   53.0379,   80.9009,   63.9639,   53.9269,
		 53.4898,   68.0528,   63.9158,   45.2788,   85.8417,  119.8047,   52.9677,   44.2307,
		 46.3936,   34.7566,  110.1196,   35.2826,   79.5455,   39.5085,   94.5715,   40.2345,
		 47.7974,   67.2604,  147.0234,   30.2864,   49.9493,   88.6123,   61.8753,   85.3382,
		 49.8012,   35.0642,   51.3272,   55.2901,   80.4531,   56.1161,   69.5791,   41.8420,
		 82.1050
	), tol = 1e-4)

	# NOTE: New implementation produces different results for trends 01 and 11.
	decomposed <- data_decomposition(df$max, df$year, S01)
	expect_equal(decomposed, c(
		67.5444, 73.6057, 75.8476, 54.1693, 67.6624, 69.3686, 63.9093, 60.6130,
		60.7010, 77.6823, 78.4552, 73.6528, 79.0888, 70.7547, 70.1827, 68.0063,
		67.9643, 65.0101, 70.1484, 63.1265, 70.4073, 59.4441, 65.7484, 72.6059,
		69.7764, 81.1832, 76.9701, 80.0237, 69.6225, 73.5394, 70.0207, 67.7516,
		76.2135, 66.1034, 67.2758, 72.9233, 67.3155, 69.3043, 78.3954, 76.2334,
		73.0669, 69.2923, 72.3895, 81.4037, 66.2737, 81.4732, 77.7311, 71.5238,
		65.2226, 69.3671, 77.4380, 83.3095, 70.6481, 77.1176, 73.2419, 70.9984,
		70.9465, 74.2247, 73.3308, 69.2929, 78.1142, 85.3668, 71.1003, 69.3046,
		69.8132, 67.4594, 82.9842, 67.7094, 76.7030, 68.6909, 79.6715, 68.9521,
		70.4846, 74.2962, 89.6280, 67.2777, 71.0630, 78.3539, 73.3586, 77.7130,
		71.1847, 68.5392, 71.5318, 72.2752, 76.7803, 72.4751, 74.8617, 70.0402,
		77.0432
	), tol = 1e-4)

	decomposed <- data_decomposition(df$max, df$year, S11)
	expect_equal(decomposed, c(
		61.4034, 67.2857, 69.3766, 47.7025, 60.9853, 62.5596, 57.0202, 53.6349, 
		53.6155, 70.3760, 71.0426, 66.1770, 71.4802, 63.1160, 62.4611, 60.2166,
		60.0935, 57.0830, 62.1058, 55.0642, 62.2166, 51.2702, 57.4573, 64.1943,
		61.3237, 72.5756, 68.3370, 71.3055, 60.6207, 64.4562, 60.9215, 58.6269,
		66.9704, 56.9061, 58.0261, 63.5822, 57.9842, 59.9159, 68.8865, 66.7061,
		63.5314, 59.7552, 62.7887, 71.6854, 56.6609, 71.6867, 67.9466, 61.7651,
		55.4917, 59.5669, 67.5320, 73.3186, 60.7478, 67.1277, 63.2610, 61.0116,
		60.9336, 64.1541, 63.2431, 59.2187, 67.9300, 75.0877, 60.9356, 59.1338,
		59.6144, 57.2609, 72.6113, 57.4642, 66.3479, 58.3934, 69.2446, 58.6107,
		60.1077, 63.8616, 79.0211, 56.8741, 60.6027, 67.8019, 62.8382, 67.1307,
		60.6501, 58.0137, 60.9589, 61.6777, 66.1203, 61.8422, 64.1882, 59.3996,
		66.3154
	), tol = 1e-4)

})


test_that("data-decomposition.R works on OKANAGAN RIVER (08NM050)", {

	df <- data_local("CAN-08NM050.csv")

	decomposed <- data_decomposition(df$max, df$year, S10)
	expect_equal(decomposed, c(
		45.2427,   47.9388,   39.9348,   51.3309,   42.3270,   43.7230,   93.4191,   38.3152,
    	34.8112,   30.2773,   44.4033,   46.2994,   45.1955,   43.8915,   44.1876,   42.0836,
    	40.2797,   29.0758,   24.3218,   38.6679,   52.0639,   37.2600,   33.5561,   40.5521,
    	45.3482,   33.8442,   55.9403,   49.5364,   41.8324,   48.4285,   37.7245,   34.9206,
    	43.3167,   40.0127,   56.4088,   44.3048,   66.9009,   65.0970,   39.4930,   52.0891,
    	34.5852,   17.6812,   36.1773,   43.6733,   19.4694,   31.8655,   49.5615,   53.3576,
    	32.8536,   46.0497,   63.2458,   27.1418,   62.4379,   60.5339,   45.4300,   30.0261,
    	78.0221,   18.7182,   29.3142,   59.6103,   57.1064,   61.5024,   55.3985,   25.8945,
    	49.8906,   19.6867,   11.1827,   41.3788,   66.3748,   50.5709,   16.9670,   54.8630,
    	27.7591,   43.6552,   61.5512,   71.5473,   34.7433,   50.7394,   48.8355,    7.8315,
    	44.2276,    5.5236,   33.7197,   42.6158,   56.8118,   17.4079,   39.2039,    1.0000,
    	29.8961,   46.4921,   57.5882,   51.9842,   42.9803,   26.5764,   55.4724,   63.4685,
    	51.4645
	), tol = 1e-4)

	decomposed <- data_decomposition(df$max, df$year, S01)
	expect_equal(decomposed, c(
		26.8871,   29.1061,   24.3114,   32.0651,   26.7386,   28.0233,   58.8222,   25.5375,
    	23.8710,   21.6462,   30.2778,   31.6970,   31.3889,   30.9777,   31.4551,   30.6201,
    	29.9666,   24.3635,   22.2634,   30.0600,   37.1860,   29.9508,   28.4058,   32.1574,
    	34.7540,   29.4588,   40.2483,   37.4061,   34.0218,   37.2855,   32.6102,   31.5893,
    	35.5777,   34.3268,   41.6951,   36.6077,   46.4554,   45.7809,   35.1465,   40.5708,
    	33.5208,   26.8498,   34.5772,   37.7664,   28.3536,   33.4623,   40.5365,   42.1321,
    	34.4292,   39.6048,   46.1883,   32.8565,   46.0502,   45.4353,   40.0523,   34.6524,
    	51.9103,   31.0049,   34.9153,   45.6024,   44.8193,   46.4062,   44.4089,   34.5746,
    	42.7437,   32.8436,   30.2244,   40.2600,   48.4609,   43.4395,   32.8214,   44.9747,
    	36.5426,   41.6346,   47.2712,   50.4001,   39.2129,   44.1712,   43.6781,   31.5197,
    	42.4755,   31.1707,   39.5809,   42.2720,   46.4552,   35.2275,   41.5645,   30.8576,
    	39.1334,   43.8696,   47.0199,   45.5311,   43.1312,   38.7506,   46.6611,   48.8624,
    	45.7017
 	), tol = 1e-4)

	decomposed <- data_decomposition(df$max, df$year, S11)
	expect_equal(decomposed, c(
    	17.3133,   19.2397,   13.4782,   21.5401,   15.1938,   16.1584,   49.9534,   12.5076,
    	10.2140,    7.2963,   16.5628,   17.7685,   17.0423,   16.2064,   16.3827,   15.0800,
    	13.9873,    7.2608,    4.5150,   13.0838,   20.9241,   12.3192,   10.2328,   14.2458,
    	16.9470,   10.5455,   22.7440,   19.1870,   14.9954,   18.5261,   12.8290,   11.3819,
    	15.7855,   14.0801,   22.4677,   16.2782,   27.6114,   26.6090,   13.8847,   20.0584,
    	11.5320,    3.4370,   12.3571,   15.9281,    4.5713,   10.4273,   18.6353,   20.3483,
    	10.9965,   16.9788,   24.6565,    8.5665,   24.1603,   23.2625,   16.6541,   10.0157,
    	30.5600,    5.3016,    9.8366,   22.5375,   21.4479,   23.2158,   20.6647,    8.6482,
    	18.3714,    6.2581,    2.9408,   14.9510,   24.7578,   18.5389,    5.5171,   20.1477,
    	 9.7698,   15.8359,   22.5760,   26.2713,   12.5153,   18.4446,   17.7269,    2.7553,
    	16.0285,    2.0838,   12.2605,   15.4452,   20.4646,    6.5881,   14.2546,    1.0000,
    	11.0578,   16.7766,   20.5523,   18.6231,   15.5708,   10.0752,   19.7304,   22.3537,
    	18.3624
 	), tol = 1e-4)

})
