% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multinom2poisson.R
\name{multinom2poisson}
\alias{multinom2poisson}
\title{Recover Poisson NMF Fit from Multinomial Topic Model Fit}
\usage{
multinom2poisson(fit, X)
}
\arguments{
\item{fit}{An object of class \dQuote{multinom_topic_model_fit},
such as an output from \code{poisson2multinom}. If a Poisson NMF
fit is provided (that is, an object of class
\dQuote{poisson_nmf_fit}), the fit object is immediately returned
\dQuote{as is}.}

\item{X}{Optional n x m matrix of counts, or pseudocounts. It can
be a sparse matrix (class \code{"dgCMatrix"}) or dense matrix
(class \code{"matrix"}). This only needs to be provided if the
document sizes \code{fit$s} are not available.}
}
\value{
The return value is the list \code{fit}, in which matrices
  \code{fit$F} and \code{fit$L} specify the factors and loadings in
  the Poisson non-negative matrix factorization; specifically,
  the counts matrix is modeled by the low-rank matrix product
  \code{tcrossprod(fit$L,fit$F)}.
}
\description{
This function recovers parameter estimates of the
  Poisson non-negative matrix factorization (NMF) given parameter
  estimates for a multinomial topic model.
}
