% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_TestItemFunctions.R
\name{ITBiserial}
\alias{ITBiserial}
\alias{ITBiserial.default}
\alias{ITBiserial.binary}
\title{Item-Total Biserial Correlation}
\usage{
ITBiserial(U, na = NULL, Z = NULL, w = NULL)

\method{ITBiserial}{default}(U, na = NULL, Z = NULL, w = NULL)

\method{ITBiserial}{binary}(U, na = NULL, Z = NULL, w = NULL)
}
\arguments{
\item{U}{Either an object of class "exametrika" or raw data. When raw data is given,
it is converted to the exametrika class with the \code{\link{dataFormat}} function.}

\item{na}{Values to be treated as missing values.}

\item{Z}{Missing indicator matrix of type matrix or data.frame. Values of 1 indicate
observed responses, while 0 indicates missing data.}

\item{w}{Item weight vector specifying the relative importance of each item.}
}
\value{
A numeric vector of item-total biserial correlations. Values range
from -1 to 1, where:
\itemize{
\item Values near 1: Strong positive discrimination
\item Values near 0: No discrimination
\item Negative values: Potential item problems
}
}
\description{
The Item-Total Biserial Correlation computes the biserial correlation
between each item and the total score. This function is applicable only
to binary response data.

This correlation provides a measure of item discrimination, indicating how well
each item distinguishes between high and low performing examinees.
}
\note{
This function is implemented using a binary data compatibility wrapper and
will raise an error if used with polytomous data.

The biserial correlation is generally preferred over the point-biserial
correlation when the dichotomization is artificial (i.e., when the underlying
trait is continuous).
}
\examples{
# using sample dataset
ITBiserial(J15S500)
}
